package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.system.service.SysMqMessageMngService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 删除过期的临时资源.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Component
public class ClearExpiredMqMessageTask implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClearExpiredMqMessageTask.class);

    @Autowired
    private SysMqMessageMngService mngService;

    @Override
    public void run() {
        var expiredTime = this.calcExpiredTime();
        logger.info("删除过期的MQ消息：{}", DatetimeUtil.toStr(expiredTime));
        mngService.deleteExpiredMessage(expiredTime).computeData();
    }

    private LocalDateTime calcExpiredTime() {
        return LocalDateTime.now().minusMonths(2);
    }
}
