package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 删除过期的临时资源.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Component
public class ClearExpiredResourcesTask implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClearExpiredResourcesTask.class);

    @Autowired
    private ResourceByteMngService mngService;
    @Autowired
    private ResourceByteRepoProc resourceByteRepoProc;

    @Override
    public void run() {
        var expiredFiles = resourceByteRepoProc.queryExpiredTempResource(LocalDateTime.now().plusDays(2), 50);
        if (expiredFiles.isEmpty()) {
            return;
        }
        for (SysResourceByteDO expiredFile : expiredFiles) {
            mngService.delete(expiredFile.getId());
            logger.info("删除过期的临时文件：{}，{}", expiredFile.getResourceKey(), expiredFile.getCreateTime());
        }
    }
}
