package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 删除过期的外部接口日志.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/20 周六
 */
@Component
public class ClearExpiredSysThirdApiLogTask implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClearExpiredSysThirdApiLogTask.class);

    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private ThirdApiLogService thirdApiLogService;

    @Override
    public void run() {
        var keepDays = systemProperties.getThirdApiLog().getLogKeepDays();
        if (keepDays == null || keepDays < 1) {
            logger.info("不清理过期日志：{}", keepDays);
            return;
        }

        LocalDateTime expiredTime = LocalDateTime.now().minusDays(keepDays);
        thirdApiLogService.clearExpiredLogs(expiredTime);
    }
}
