package com.elitescloud.cloudt.system.rest.test;

import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/24
 */
@Component
@ConditionalOnClass(MessageQueueListener.class)
public class TestMessageQueueListener implements MessageQueueListener<FileInfoVO> {
    private static final Logger logger = LoggerFactory.getLogger(TestMessageQueueListener.class);

    @Override
    public @NotEmpty String[] channels() {
        return new String[] {"mq_wangs"};
    }

    @Override
    public void onConsume(@NotBlank String channel, @NotNull FileInfoVO payload) {
        var tenant = TenantClient.getCurrentTenant();
        logger.info("接收到消息：{}, {}", tenant == null ? null : tenant.getTenantCode(), payload);
    }
}
