package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.DataRelationQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.DataRelationRespDTO;
import com.elitescloud.cloudt.system.provider.DataRelationRpcService;
import com.elitescloud.cloudt.system.service.DataRelationInstQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@RestController
@RequestMapping(value = DataRelationRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class DataRelationRpcServiceImpl implements DataRelationRpcService {

    private DataRelationInstQueryService queryService;

    @Override
    public ApiResult<List<DataRelationRespDTO>> query(DataRelationQueryDTO queryDTO) {
        return queryService.query(queryDTO);
    }

    @Override
    public ApiResult<List<DataRelationRespDTO>> queryByRefData(DataRelationQueryDTO queryDTO) {
        return queryService.queryByRefData(queryDTO);
    }

    @Autowired
    public void setQueryService(DataRelationInstQueryService queryService) {
        this.queryService = queryService;
    }
}
