package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import com.elitescloud.cloudt.system.service.MenuMngService;
import com.elitescloud.cloudt.system.service.MenuQueryService;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author kevin nc
 * 2023/6/25
 */
@RestController
@RequestMapping(value = SysMenuRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysMenuRpcServiceImpl implements SysMenuRpcService {
    private SysPlatformMenusRepo sysPlatformMenusRepo;
    private MenuMngService mngService;
    private MenuQueryService queryService;

    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;

    @Override
    public ApiResult<Long> addMenu(SysMenuSaveDTO saveDTO) {
        return mngService.addMenu(saveDTO);
    }

    @Override
    public ApiResult<String> removeMenu(String menuCode) {
        return mngService.removeMenu(menuCode);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg = false)
    public ApiResult<List<SysPlatformMenusDTO>> getPlatformMenuByAppCodeList(List<String> appCodeList) {
        List<SysPlatformMenusDTO> listDto = new ArrayList<>();
        sysPlatformMenusRepo.findAll(QDO.menusAppCode.in(appCodeList))
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
                    listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO));
                });
        return ApiResult.ok(listDto);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg = false)
    public ApiResult<List<SysPlatformMenusDTO>> getTenantMenuByAppCodeList(Long tenantId,
                                                                           List<String> appCodeList) {
        List<SysPlatformMenusDTO> listDto = new ArrayList<>();
        sysPlatformMenusRepo.findAll(QDO.menusAppCode.in(appCodeList).and(QDO.tenantId.eq(tenantId)))
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
                    listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO));
                });
        return ApiResult.ok(listDto);
    }

    @Override
    public ApiResult<SysPlatformMenusDTO> getMenuInfo(String menuCode) {
        return queryService.getMenuInfo(menuCode);
    }

    @Override
    public ApiResult<List<SysPlatformMenusDTO>> getMenuInfo(Set<String> menuCodes) {
        return queryService.getMenuInfo(menuCodes);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> getMenuWithParents(String menuCode) {
        return queryService.getMenuWithParents(menuCode);
    }

    @Autowired
    public void setSysPlatformMenusRepo(SysPlatformMenusRepo sysPlatformMenusRepo) {
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
    }

    @Autowired
    public void setMngService(MenuMngService mngService) {
        this.mngService = mngService;
    }

    @Autowired
    public void setQueryService(MenuQueryService queryService) {
        this.queryService = queryService;
    }
}
