package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author Chris
 * 2021-08-31
 */
@RestController
@RequestMapping(value = SysSettingService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysSettingRpcServiceImpl implements SysSettingService {

    @Autowired
    private ISysSettingService sysSettingService;

    @Override
    public PagingVO<SysSettingVO> search(SysSettingQParam param) {
        return sysSettingService.search(param);
    }

    @Override
    public List<SysSettingVO> all() {
        return sysSettingService.all();
    }

    @Override
    public SysSettingVO oneById(Long id) {
        return sysSettingService.oneById(id);
    }

    @Override
    public SysSettingVO oneByNo(String no) {
        return sysSettingService.oneByNo(no);
    }

    @Override
    public Long create(SysSettingVO sysSetting) {
        return sysSettingService.create(sysSetting);
    }

    @Override
    public void update(SysSettingVO sysSettingVO) {
        sysSettingService.update(sysSettingVO);
    }

    @Override
    public void removeByIds(List<Long> ids) {
        sysSettingService.removeByIds(ids);
    }

    @Override
    public void removeByNos(List<String> nos) {
        sysSettingService.removeByNos(nos);
    }
}
