package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.extend.SysThirdPartyAccountRpcService;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@RestController
@RequestMapping(value = SysThirdPartyAccountRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysThirdPartyAccountRpcServiceImpl implements SysThirdPartyAccountRpcService {

    @Autowired
    private ThirdPartAccountQueryService queryService;

    @Override
    public ApiResult<Long> getTenantIdByAccount(String account) {
        return queryService.getTenantIdOfAccount(account);
    }
}
