package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessObjectPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.*;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessObjectSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessOperationSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.UpdateFieldPermissionFilterParam;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 业务对象管理接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
public interface BusinessObjectMngService {

    /**
     * 测试解析OpenApi
     *
     * @param openApiId          openApi的ID
     * @param openApiOperationId openApi的操作ID
     * @param save               是否保存
     * @return 结果
     */
    ApiResult<Boolean> testAnalyzeOpenApi(@NotNull Long openApiId, Long openApiOperationId, Boolean save);

    ApiResult<List<BusinessOperationParamBO>> queryBusinessOperationParam(String operationCode,
                                                                          BusinessObjectParamInEnum paramInEnum);

    /**
     * 根据OpenApi生成业务对象
     *
     * @param openApiId openApi的ID
     * @return openApi的ID
     */
    ApiResult<Long> generateByOpenApi(@NotNull Long openApiId);

    /**
     * 保存业务对象信息
     *
     * @param saveVO 业务对象信息
     * @return 业务对象ID
     */
    ApiResult<Long> saveBusinessObject(BusinessObjectSaveVO saveVO);

    /**
     * 保存业务操作信息
     *
     * @param saveVO 业务操作信息
     * @return 业务操作ID
     */
    ApiResult<Long> saveBusinessOperation(BusinessOperationSaveVO saveVO);

    /**
     * 批量保存业务操作信息
     *
     * @param saveVOList 业务操作信息
     * @return 业务操作ID
     */
    ApiResult<Set<Long>> saveBusinessOperation(List<BusinessOperationSaveVO> saveVOList);

    /**
     * 修改字段的数据权限
     *
     * @param businessParamId 业务对象字段ID
     * @param enabled         是否启用数据权限
     * @return 业务对象字段ID
     */
    ApiResult<Long> updateDataPermissionEnabledOfParam(@NotNull Long businessParamId, Boolean enabled);


    /**
     * 修改字段的字段权限
     *
     * @param businessParamId 业务对象字段ID
     * @param enabled         是否启用字段权限
     * @return 业务对象字段ID
     */
    ApiResult<Long> updateFieldPermissionEnabledOfParam(@NotNull Long businessParamId, Boolean enabled);

    /**
     * 分页查询业务对象
     *
     * @param queryVO 查询参数
     * @return 业务对象
     */
    ApiResult<PagingVO<BusinessObjectPageRespVO>> pageObject(BusinessObjectPageQueryVO queryVO);

    /**
     * 获取详细信息
     *
     * @param id 业务对象ID
     * @return 业务对象信息
     */
    ApiResult<BusinessObjectDetailRespVO> getDetail(@NotNull Long id);

    /**
     * 获取业务操作
     *
     * @param businessOperationId 业务操作ID
     * @return 业务操作信息
     */
    ApiResult<BusinessOperationRespVO> getBusinessOperation(@NotNull Long businessOperationId);

    /**
     * 分页查询业务操作
     *
     * @param queryVO 查询参数
     * @return 业务操作列表
     */
    ApiResult<PagingVO<BusinessOperationPageRespVO>> pageOperation(BusinessOperationPageQueryVO queryVO);

    /**
     * 获取业务对象的权限字段
     *
     * @param id 业务对象ID
     * @return 字段列表
     */
    ApiResult<List<BusinessPermissionParamRespVO>> listPermissionFields(@NotNull Long id);

    /**
     * 获取业务操作的权限字段
     *
     * @param operationId 操作ID
     * @return 字段列表
     */
    ApiResult<List<BusinessPermissionParamRespVO>> listOperationPermissionFields(@NotNull Long operationId);


    /**
     * 更新业务对象操作参数是否权限过滤
     */
    ApiResult<Boolean> updateBusinessOperationFieldPermissionFilter(UpdateFieldPermissionFilterParam param);
}
