package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
public interface DataRelationMngService {

    /**
     * 保存配置
     *
     * @param saveVO
     * @return
     */
    ApiResult<Long> save(DataRelationSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    ApiResult<List<Long>> delete(List<Long> ids);

    /**
     * 修改启用状态
     *
     * @param id
     * @param enabled
     * @return
     */
    ApiResult<Long> updateEnabled(Long id, Boolean enabled);

    /**
     * 获取配置
     *
     * @param id
     * @return
     */
    ApiResult<DataRelationEditRespVO> get(Long id);

    /**
     * 分页查询
     *
     * @param queryVO
     * @return
     */
    ApiResult<PagingVO<DataRelationPagedRespVO>> page(DataRelationPageQueryVO queryVO);
}
