package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiDetailVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiRespVO;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 15:52
 * @Description:
 */
public interface InfinityApiService {

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<InfinityApiRespVO> infinityApiByParam(ApiQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    InfinityApiDetailVO infinityApiById(Long id);

    /**
     * 明细查询
     *
     * @param apiCode 接口编码
     * @return 接口
     */
    InfinityApiDetailVO infinityApiByApiCode(String apiCode);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ApiSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, int status);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);
}
