package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:14
 * @Description:
 */
public interface InfinityTrackService {
    /**
     * 接口(被动)调用日志
     *
     * @param request      客户端请求
     * @param response     客户端响应
     * @param responseBody 接口返回结果
     */
    void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody);

    /**
     * 接口(主动)调用日志
     *
     * @param requestParam 接口请求参数
     * @since 0.1.12-SNAPSHOT
     */
    void record(InfinityLogVO requestParam);
}
