package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserListRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserSaveVO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
public interface SubUserMngService {

    /**
     * 保存子账号信息
     *
     * @param saveVO 保存信息
     * @return 子账号ID
     */
    ApiResult<Long> save(SubUserSaveVO saveVO);

    /**
     * 批量保存
     *
     * @param saveVO 保存信息
     * @return 子账号ID
     */
    ApiResult<List<Long>> saveBatch(SubUserBatchSaveVO saveVO);

    /**
     * 查询子账号列表
     *
     * @return 账号列表
     */
    ApiResult<List<SubUserListRespVO>> querySubUserList(BelongType belongType, String belongerId, String roleCode);

    /**
     * 获取详细信息
     *
     * @param id 子账号ID
     * @return 详细信息
     */
    ApiResult<SubUserDetailRespVO> get(Long id);

    /**
     * 查看子账号的角色信息
     *
     * @param id 子账号ID
     * @return 角色信息列表
     */
    ApiResult<List<IdCodeNameParam>> getRolesOfSubUser(Long id);

    /**
     * 获取账号分配的菜单
     *
     * @param id 子账号ID
     * @return 菜单编码
     */
    ApiResult<Set<String>> getMenuCodesOfSubUser(Long id);

    /**
     * 删除子账号记录
     *
     * @param ids     记录ID
     * @param delUser 是否删除登录账号，默认否
     * @return 记录ID
     */
    ApiResult<Set<Long>> del(Set<Long> ids, Boolean delUser);
}
