package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.common.TrackType;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:30
 * @Description:
 */
public interface SysLogService {

    void info(String trackType, String message, Object eventParam);

    void error(String trackType, String message, Object eventParam, Throwable ex);

    void error(String trackType, String message, Object eventParam, String trackTypeError);

    default void info(String message) {
        this.info(TrackType.LOG_SYSTEM.getCode(), message, (Object) null);
    }

    default void info(String message, Object eventParam) {
        this.info(TrackType.LOG_SYSTEM.getCode(), message, eventParam);
    }

    default void error(String message, Object eventParam, Throwable ex) {
        this.error(TrackType.LOG_SYSTEM.getCode(), message, eventParam, ex);
    }

    default void error(String message, Object eventParam, String trackTypeError) {
        this.error(TrackType.LOG_SYSTEM.getCode(), message, eventParam, trackTypeError);
    }

}
