package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.devops.BasicDataRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordExportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordImportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ImportBasicDataSaveVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 系统数据服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public interface SystemDataService {

    /**
     * 获取数据类型
     *
     * @return 数据类型列表
     */
    ApiResult<List<CodeNameParam>> listDataType();

    /**
     * 导出系统数据
     *
     * @param saveVO 导出参数
     * @return 结果
     */
    ApiResult<Boolean> exportData(ExportBasicDataSaveVO saveVO);

    /**
     * 分页查询导出记录
     *
     * @param queryVO 查询参数
     * @return 记录列表
     */
    ApiResult<PagingVO<BasicRecordExportPageRespVO>> pageExportedRecord(BasicDataRecordPageQueryVO queryVO);

    /**
     * 分页查询导入记录
     *
     * @param queryVO 查询参数
     * @return 记录列表
     */
    ApiResult<PagingVO<BasicRecordImportPageRespVO>> pageImportedRecord(BasicDataRecordPageQueryVO queryVO);

    /**
     * 导入数据
     *
     * @param file   文件
     * @param saveVO 导入参数
     * @return 导入结果
     */
    ApiResult<Boolean> importData(MultipartFile file, ImportBasicDataSaveVO saveVO);
}
