package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.model.vo.save.extend.ThirdApiLogSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/26
 */
public interface ThirdApiRetrySupportService {

    /**
     * 保存日志
     *
     * @param logDTO 日志信息
     * @return 日志ID
     */
    ApiResult<Long> saveLog(ThirdApiLogDTO logDTO);

    /**
     * 保存日志
     *
     * @param saveVO    保存
     * @param retrySend 是否重试发送
     * @return 记录ID
     */
    ApiResult<Long> saveLog(ThirdApiLogSaveVO saveVO, boolean retrySend);

    /**
     * 尝试判断是否可以发送
     *
     * @param id
     * @param version
     * @return
     */
    ApiResult<Boolean> trySend(Long id, Integer version);

    /**
     * 删除重试记录
     *
     * @param id
     * @param reason
     * @return
     */
    ApiResult<Boolean> deleteRetry(Long id, String reason);

    /**
     * 更新重试结果
     *
     * @param id
     * @param success
     * @param reason
     */
    ApiResult<Boolean> updateRetryResult(Long id, boolean success, String reason);

    /**
     * 更新响应结果
     *
     * @param id
     * @param manual
     * @param success
     * @param reason
     * @param respBody
     * @return
     */
    ApiResult<Boolean> updateRetryRespResult(Long id, boolean manual, boolean success, String reason, String respBody);
}
