package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.*;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:33
 * @Description:
 */
public interface ThirdApiService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<ThirdApiPagingVO> ThirdApiPageBy(ThirdApiPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ThirdApiRespVO> ThirdApiByParam(ThirdApiQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ThirdApiRespVO ThirdApiById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ThirdApiSaveParamVO saveParam);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    long delete(List<Long> ids);
}
