package com.elitescloud.cloudt.system.service.devops;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheMethodRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheServiceRespVO;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/12
 */
public interface CacheMngService {

    /**
     * 获取服务列表
     *
     * @param serviceId 服务标识
     * @return 缓存列表
     */
    ApiResult<List<CacheServiceRespVO>> queryCacheServices(@NotBlank String serviceId);

    /**
     * 获取缓存服务的方法
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @return 方法列表
     */
    ApiResult<List<CacheMethodRespVO>> queryCacheMethods(@NotBlank String serviceId, @NotBlank String cacheServiceKey);

    /**
     * 根据缓存方法查询
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @param method          缓存方法
     * @param params          入参
     * @param tenantCode      租户编码
     * @return 缓存数据
     */
    ApiResult<Object> queryCacheDataByCacheMethod(@NotBlank String serviceId, @NotBlank String cacheServiceKey, @NotBlank String method,
                                                  Object[] params, String tenantCode);

    /**
     * 获取缓存的数据项
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @param tenantCode      租户编码
     * @return 数据项
     */
    ApiResult<List<String>> queryCacheItems(@NotBlank String serviceId, @NotBlank String cacheServiceKey, String tenantCode);

    /**
     * 获取缓存项数据
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @param cacheItem       数据项
     * @param tenantCode      租户编码
     * @return 数据
     */
    ApiResult<Object> queryCacheItemData(@NotBlank String serviceId, @NotBlank String cacheServiceKey, @NotBlank String cacheItem, String tenantCode);

    /**
     * 获取服务下的所有缓存数据
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @param tenantCode      租户编码
     * @return 数据
     */
    ApiResult<Map<String, Object>> queryAllCacheItemData(@NotBlank String serviceId, @NotBlank String cacheServiceKey, String tenantCode);

    /**
     * 重新加载缓存
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @return 数据项
     */
    ApiResult<Boolean> reload(@NotBlank String serviceId, @NotBlank String cacheServiceKey);

    /**
     * 清空缓存
     *
     * @param serviceId       服务标识
     * @param cacheServiceKey 缓存服务标识Key
     * @return 数据项
     */
    ApiResult<Boolean> clear(@NotBlank String serviceId, String cacheServiceKey);
}
