package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.service.TenantAsyncSpi;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:18
 * @Description:
 */
@Slf4j
@RequiredArgsConstructor
@Service
public class CloudtTenantAsyncService implements TenantAsyncSpi {
    @Resource
    private TenantWrapper tenantWrapper;

    @Override
    public <T> CompletableFuture<T> supplyAsync(Supplier<T> executor, String tenantCode) {
        return tenantWrapper.supplyAsync(executor, tenantCode);
    }

    @Override
    public <T> CompletableFuture<Void> runAsync(Runnable executor, String tenantCode) {
        return tenantWrapper.runAsync(executor, tenantCode);
    }
}
