package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.util.IamUserUtil;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.apache.skywalking.apm.toolkit.trace.SupplierWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:11
 * @Description:
 */
@Component
public class TenantWrapper {
    private static final Logger log = LoggerFactory.getLogger(TenantWrapper.class);
    @Resource
    private TaskExecutor taskExecutor;
    @Resource
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> executor, String tenantCode) {
        return CompletableFuture.supplyAsync(SupplierWrapper.of(() -> {
            return this.byTenantDirectly(executor, tenantCode);
        }), this.taskExecutor);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> executor) {
        log.debug("[PHOENIX-CLOUDT] CURRENT TENANT CODE: {}", IamUserUtil.currentTenantCode());
        return this.supplyAsync(executor, IamUserUtil.currentTenantCode());
    }

    public <T> CompletableFuture<Void> runAsync(Runnable executor, String tenantCode) {
        return CompletableFuture.runAsync(RunnableWrapper.of(() -> {
            this.byTenantDirectly(executor, tenantCode);
        }), this.taskExecutor);
    }

    public <T> CompletableFuture<Void> runAsync(Runnable executor) {
        log.debug("[PHOENIX-CLOUDT] CURRENT TENANT CODE: {}", IamUserUtil.currentTenantCode());
        return this.runAsync(executor, IamUserUtil.currentTenantCode());
    }

    public <T> T byTenantDirectly(Supplier<T> executor, String tenantCode) {
        return this.tenantDataIsolateProvider.byTenantDirectly(executor, tenantCode);
    }

    public <T> T byTenantDirectly(Supplier<T> executor) {
        return this.byTenantDirectly(executor, IamUserUtil.currentTenantCode());
    }

    public void byTenantDirectly(Runnable executor, String tenantCode) {
        Supplier<Void> useSupplier = () -> {
            executor.run();
            return null;
        };
        this.tenantDataIsolateProvider.byTenantDirectly(useSupplier, tenantCode);
    }

    public void byTenantDirectly(Runnable executor) {
        this.byTenantDirectly(executor, IamUserUtil.currentTenantCode());
    }

    public void byAllTenant(Runnable executor) {
        this.tenantDataIsolateProvider.byAllTenant(() -> {
            executor.run();
            return null;
        });
    }

    public TenantWrapper() {
    }
}
