package com.elitescloud.cloudt.system.service.impl.old;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.constant.CommonConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.spi.common.ServiceProviderLoader;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.constant.SysMessenger;
import com.elitescloud.cloudt.constant.YstSetting;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.old.SysUserConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.param.SysUserQueryParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.service.SysUserTerminalService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.service.repo.SysUserCompanyRepoProc;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepo;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepoProc;
import com.elitescloud.cloudt.system.spi.SysUserServiceSpi;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitescloud.coord.messenger.sender.provider.MsgCarrierDubboService;
import com.elitescloud.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * 2020/6/16
 */
@Service
@Slf4j
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class SysUserServiceImpl implements ISysUserService {

    @Autowired
    private SysUserCompanyRepoProc userCompanyRepoProc;
    @Autowired
    private SysUserRepo sysUserRepo;
    @Autowired
    private SysUserRepoProc sysUserRepoProc;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ISysSettingService sysSettingService;
    @Autowired
    private SysUserTerminalService userTerminalService;
    @Autowired
    private MsgCarrierDubboService msgCarrierDubboService;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private UserMngManager userMngManager;
    @Autowired
    private UserQueryService userQueryService;

    private AtomicBoolean userServiceSpiLoaded = new AtomicBoolean(false);
    private List<SysUserServiceSpi> userServiceSpiList = new ArrayList<>();

    @Override
    public PagingVO<SysUserVO> search(SysUserQueryParam param) {
        val users = sysUserRepoProc.selectSysUser(param);
        List<SysUserDO> records = users.getRecords();
        if (records == null || records.isEmpty()) {
            return PagingVO.<SysUserVO>builder().build();
        }
        val userIds = records.stream().map(BaseModel::getId).collect(Collectors.toList());
//        val userRoles = sysUserRoleService.listRolesByUserIds(userIds);

        val userVos = users.getRecords().stream().map(u -> {
            SysUserVO userVo = SysUserConvert.INSTANCE.doToVo(u);
//            if (userRoles.containsKey(u.getId())) {
//                userVo.setRoleNames(userRoles.get(u.getId())
//                        .stream().map(SysRoleVO::getName).collect(Collectors.joining(",")));
//            }
            return userVo;
        }).collect(Collectors.toList());

        return PagingVO.<SysUserVO>builder()
                .total(users.getTotal())
                .records(userVos)
                .build();
    }

    @Override
    public SysUserDetailsVO findDetailsById(Long id) {
        var currentTenant = tenantClientProvider.getCurrentTenant();
        var detailsVO = sysUserRepoProc.findDetailsById(id);

        if (detailsVO != null) {
            tenantDataIsolateProvider.byTenantDirectly(() -> {
//                // 获取应用角色ID列表
//                detailsVO.setRoleIds(sysUserRoleService.findUserRoleDtoByUserIds(Collections.singletonList(id)).stream()
//                        .map(role -> role.getRoleId().toString()).collect(Collectors.toList()));
//                // 获取数据角色ID列表
//                detailsVO.setDataRoleIds(sysUserDataRoleService.findUserDataRoleDtoByUserIds(Collections.singletonList(id)).stream()
//                        .map(dataRole -> dataRole.getDataRoleId().toString()).collect(Collectors.toList()));
//                // 获取流程角色ID列表
//                detailsVO.setFlowRoleIds(sysUserFlowRoleService.findUserFlowRoleDtoByUserIds(Collections.singletonList(id)).stream()
//                        .map(flowRole -> flowRole.getFlowRoleId().toString()).collect(Collectors.toList()));

                // 获取用户终端
                var userTerminal = userTerminalService.getByUser(id);
                if (CollUtil.isNotEmpty(userTerminal.getData())) {
                    detailsVO.setTerminals(userTerminal.getData());
                }

                var userCompany = userCompanyRepoProc.queryByUserId(id);
                if (userCompany != null) {
                    detailsVO.setOuId(userCompany.getOuId());
                    detailsVO.setOuCode(userCompany.getOuCode());
                    detailsVO.setOuName(userCompany.getOuName());
                }

                return null;
            }, currentTenant);
        }

        return detailsVO;
    }

    @Override
    public SysUserDTO getById(Long id) {
        return sysUserRepo.findById(id).map(u -> {
            val userDto = SysUserConvert.INSTANCE.doToDto(u);

            return userDto;
        }).orElse(null);
    }

    @Override
    public List<SysUserVO> getByIds(List<Long> ids) {
        return sysUserRepo.findAllByIdIn(ids).stream().map(SysUserConvert.INSTANCE::doToVo)
                .collect(Collectors.toList());
    }

    @Override
    public SysUserDTO getUserByUsername(String username) {
        return userQueryService.getUserByUsername(username);
    }

    @Override
    public SysUserDTO getUserByMobile(String mobile) {
        return userQueryService.getUserByMobile(mobile);
    }

    @Override
    public SysUserDTO getUserByEmail(String email) {
        return userQueryService.getUserByEmail(email);
    }

    @Override
    public SysUserDTO getUserById(Long id) {
        return userQueryService.getUserById(id);
    }

    @Override
    public SysUserDTO getUserByAccount(String account) {
        return userQueryService.getUserByAccount(account);
    }

    @Override
    public SysUserDTO getUserByWechatOpenid(String wechatOpenid) {
        return userQueryService.getUserByWechatOpenid(wechatOpenid);
    }

    @Override
    public Long getUserIdByUsername(String username) {
        if (StringUtils.isBlank(username)) {
            return null;
        }

        return sysUserRepoProc.getIdByUsername(username);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long create(SysUserNewParam userNewParam, String password) throws BusinessException {
        var currentUser = SecurityContextUtil.currentUser();
        checkForAdd(userNewParam, currentUser);

        var sysUser = SysUserConvert.INSTANCE.newToDo(userNewParam);

        // 如果没有指定密码，则使用默认密码
        var notifySettings = sysSettingService.findSettingsBySettingNo(YstSetting.PWD_NOTIFY_SETTING_NO);
        String rawPassword;
        if (StringUtils.isNotBlank(password)) {
            rawPassword = password;
        } else {
            if (CollectionUtils.isEmpty(notifySettings)) {
                // 如果没有指定密码发送方式，则使用系统默认密码
                rawPassword = generateDefaultPwd();
            } else {
                // 如果有指定密码的通知方式，则使用随机密码
                rawPassword = generateRandomPwd();
            }
        }
        sysUser.setPassword(passwordEncoder.encode(rawPassword));

        val newUser = sysUserRepo.save(sysUser);

        var id = newUser.getId();

        SysTenantDTO tenantDTO = null;
        if (userNewParam.getTenantId() != null) {
            tenantDTO = tenantClientProvider.getTenant(userNewParam.getTenantId());
            if (tenantDTO == null) {
                throw new BusinessException("租户不存在");
            }
        }

        tenantDTO = ObjectUtil.defaultIfNull(tenantDTO, obtainCurrentTenantForCreateUser(currentUser));

        tenantDataIsolateProvider.byTenantDirectly(() -> {
            // 创建用户和应用角色绑定关系
//            if (!CollectionUtils.isEmpty(userNewParam.getRoleIds())) {
//                Optional.of(userNewParam.getRoleIds()).ifPresent(roleIds -> {
//                    val userRoles = roleIds.stream().map(roleId -> new SysUserRoleVO()
//                            .setUserId(id)
//                            .setRoleId(roleId)
//                    ).collect(Collectors.toList());
//                    sysUserRoleService.saveAll(userRoles);
//                });
//            }
//
//            // 创建用户和数据角色绑定关系
//            if (!CollectionUtils.isEmpty(userNewParam.getDataRoleIds())) {
//                sysUserDataRoleService.userDataRoleHardSave(id, userNewParam.getDataRoleIds());
//            }
//
//            // 创建用户和流程角色绑定关系
//            if (!CollectionUtils.isEmpty(userNewParam.getFlowRoleIds())) {
//                sysUserFlowRoleService.userFlowRoleHardSave(id, userNewParam.getFlowRoleIds());
//            }

            // 保存用户终端
            saveOrUpdateUserTerminal(id, userNewParam);

            // 保存用户公司
            saveOrUpdateUserCompany(newUser);
            return null;
        }, tenantDTO);

        // 确认用户保存成功后，发送短信通知生成的随机密码，如果是手动指定的则不发送通知
        if (StringUtils.isBlank(password) && !CollectionUtils.isEmpty(notifySettings)) {
            var notifySetting = notifySettings.get(0);
            sendPwdSmsNotify(sysUser.getMobile(), rawPassword, notifySetting.getSettingVal(), SysMessenger.TEMPLATE_CODE_PWD_INIT);
        }

        // 调用扩展服务
        expendUserServiceSpi(spi -> spi.afterUserAdd(userNewParam, id));

        return id;
    }

    private void checkForAdd(SysUserNewParam userNewParam, GeneralUserDetails currentUser) {
        if (userNewParam.getEnabled() == null) {
            // 默认未启用
            userNewParam.setEnabled(false);
        }

        // 调用扩展服务校验
        expendUserServiceSpi(spi -> spi.beforeUserAdd(userNewParam));

        // 校验用户名
        if (sysUserRepo.existsByUsername(userNewParam.getUsername())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "用户：" + userNewParam.getUsername() + ", 已经存在");
        }

        // 校验手机号
        if (StringUtils.isBlank(userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "手机号必填");
        } else if (sysUserRepo.existsByMobile(userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "相同的手机号码已经存在");
        }

        // 校验邮箱
        if (StringUtils.isNotBlank(userNewParam.getEmail()) && sysUserRepo.existsByEmail(userNewParam.getEmail())) {
            throw new BusinessException("相同的邮箱地址已经存在");
        }

        // 操作人员的角色权限判断
        checkUserPermission(currentUser, userNewParam.getRoleIds());
//        checkUserDataPermission(currentUser, userNewParam.getDataRoleIds());
//        checkUserFlowPermission(currentUser, userNewParam.getFlowRoleIds());
    }

    private void expendUserServiceSpi(Consumer<SysUserServiceSpi> userServiceSpiConsumer) {
        if (this.userServiceSpiLoaded.compareAndSet(false, true)) {
            userServiceSpiList = ServiceProviderLoader.loadProviderInstances(SysUserServiceSpi.class);
        }

        if (userServiceSpiList.isEmpty()) {
            log.info("用户管理SysUserServiceSpi无扩展实现");
            return;
        }

        for (SysUserServiceSpi spi : userServiceSpiList) {
            log.info("【{}】SPI调用...", spi.getServiceName());

            userServiceSpiConsumer.accept(spi);
        }
    }

    private SysTenantDTO obtainCurrentTenantForCreateUser(GeneralUserDetails currentUser) {
        if (currentUser != null) {
            if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
                return null;
            }
            return currentUser.getTenant();
        }

        return tenantClientProvider.getCurrentTenant();
    }

    private void checkUserPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }

        // 未登录或是超级管理员，可能是接口调用，暂不过滤
        if (currentUser == null || currentUser.isSystemAdmin()) {
            return;
        }
    }

//    private void checkUserDataPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
//        if (roleIds == null || roleIds.isEmpty()) {
//            return;
//        }
//
//        // 未登录，可能是接口调用，暂不过滤
//        if (currentUser == null || currentUser.isSystemAdmin()) {
//            return;
//        }
//
//        // 查询无权限的角色编码
//        var noPermissionRoleCodes = dataRoleService.rolesOfNoPermission(currentUser.getUser());
//        if (noPermissionRoleCodes.isEmpty()) {
//            return;
//        }
//
//        // 判断是否存在无权限操作的角色
//        var noPermissionRoleIds = dataRoleService.getIdByCode(noPermissionRoleCodes).values();
//        for (Long roleId : roleIds) {
//            if (noPermissionRoleIds.contains(roleId)) {
//                throw new BusinessException("部分数据角色无权限操作");
//            }
//        }
//    }

//    private void checkUserFlowPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
//        if (roleIds == null || roleIds.isEmpty()) {
//            return;
//        }
//
//        // 未登录，可能是接口调用，暂不过滤
//        if (currentUser == null || currentUser.isSystemAdmin()) {
//            return;
//        }
//
//        // 查询无权限的角色编码
//        var noPermissionRoleCodes = flowRoleService.rolesOfNoPermission(currentUser.getUser());
//        if (noPermissionRoleCodes.isEmpty()) {
//            return;
//        }
//
//        // 判断是否存在无权限操作的角色
//        var noPermissionRoleIds = flowRoleService.getIdByCode(noPermissionRoleCodes).values();
//        for (Long roleId : roleIds) {
//            if (noPermissionRoleIds.contains(roleId)) {
//                throw new BusinessException("部分流程角色无权限操作");
//            }
//        }
//    }

    private void saveOrUpdateUserTerminal(Long id, SysUserNewParam userNewParam) {
        var terminals = new HashSet<Terminal>(4);
        if (CollUtil.isNotEmpty(userNewParam.getTerminals())) {
            terminals.addAll(userNewParam.getTerminals());
        }
        if (CharSequenceUtil.equals(userNewParam.getSourceType(), "sys")) {
            terminals.add(Terminal.BACKEND);
        } else if (CharSequenceUtil.equals(userNewParam.getSourceType(), "wec")) {
            terminals.add(Terminal.APP);
        }

        if (!terminals.isEmpty()) {
            userTerminalService.saveForAdd(id, terminals);
            userNewParam.setTerminals(terminals);
        }
    }

    private void saveOrUpdateUserCompany(SysUserDO user) {
//        if (user.getOuId() == null) {
//            // 解绑
//            userCompanyRepoProc.deleteByUserId(user.getId());
//            return;
//        }
//
//        List<Long> ouIds = userCompanyRepoProc.getOuIdOfUser(user.getId());
//        if (ouIds.contains(user.getOuId())) {
//            // 已存在，则不需要保存
//            return;
//        }
//
//        // 解绑
//        userCompanyRepoProc.deleteByUserId(user.getId());
//
//        SysUserCompanyDO userCompanyDO = new SysUserCompanyDO();
//        userCompanyDO.setSysUserId(user.getId());
//        userCompanyDO.setOuId(user.getOuId());
//        userCompanyDO.setOuCode(user.getOuCode());
//        userCompanyDO.setOuName(user.getOuName());
//        userCompanyDO.setBindTime(LocalDateTime.now());
//        userCompanyRepo.save(userCompanyDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(SysUserUpdateParam userUpdateParam) {
        var currentUser = SecurityContextUtil.currentUser();

        val userOpt = sysUserRepo.findById(userUpdateParam.getId());
        if (userOpt.isEmpty()) {
            throw new BusinessException("ID为：" + userUpdateParam.getId() + "， 的用户不存在");
        }
        val sysUserDO = userOpt.get();

        if (StringUtils.isNotBlank(userUpdateParam.getMobile())) {
            if (sysUserRepo.existsByMobileAndIdNot(userUpdateParam.getMobile(), userUpdateParam.getId())) {
                throw new BusinessException("手机号码：" + userUpdateParam.getMobile() + ", 已经存在");
            }
        }
        if (StringUtils.isNotBlank(userUpdateParam.getEmail())) {
            if (sysUserRepo.existsByEmailAndIdNot(userUpdateParam.getEmail(), userUpdateParam.getId())) {
                throw new BusinessException("电子邮箱：" + userUpdateParam.getEmail() + ", 已经存在");
            }
        }

        // 更新用户信息
        SysUserConvert.INSTANCE.updateToDo(userUpdateParam, sysUserDO);

        // 更新数据权限所属关系
//        sysUserDO.setSecOuId(sysUserDO.getOuId());
//        sysUserDO.setSecBuId(sysUserDO.getBuId());
        sysUserRepo.save(sysUserDO);

        tenantDataIsolateProvider.byTenantAuto(() -> {
            /*
             * 修改用户信息信息时，未删除用户角色关联表信息，报联合主键已存在的错误   shihao.ma  2020-12-10
             *
             * 全删 全插 用户和应用角色的绑定关系
             */
//            sysUserRoleService.removeRolesByUserIds(Collections.singletonList(sysUserDO.getId()));
//            if (!CollectionUtils.isEmpty(userUpdateParam.getRoleIds())) {
//                val userRoles = userUpdateParam.getRoleIds().stream().map(rid -> new SysUserRoleVO()
//                        .setUserId(sysUserDO.getId())
//                        .setRoleId(rid)).collect(Collectors.toList());
//                sysUserRoleService.saveAll(userRoles);
//            }

            // 全删，全插 用户和数据角色的绑定关系
//            sysUserDataRoleService.userDataRoleHardSave(sysUserDO.getId(), userUpdateParam.getDataRoleIds());

            // 全删，全插 用户和流程角色的绑定关系
//            sysUserFlowRoleService.userFlowRoleHardSave(sysUserDO.getId(), userUpdateParam.getFlowRoleIds());

            // 保存用户终端
            if (CollUtil.isNotEmpty(userUpdateParam.getTerminals())) {
                userTerminalService.save(sysUserDO.getId(), userUpdateParam.getTerminals());
            }

            // 保存用户公司
            saveOrUpdateUserCompany(sysUserDO);

            return null;
        });

        // 扩展spi实现
        expendUserServiceSpi(spi -> spi.afterUserUpdate(sysUserDO.getId()));

        return sysUserDO.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean switchUserStatus(Long id) {
        val userOpt = sysUserRepo.findById(id);
        if (userOpt.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "ID为：" + id + "，的用户不存在");
        }
        val user = userOpt.get();
        user.setEnabled(!user.getEnabled());
        sysUserRepo.save(user);
        return user.getEnabled();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
//        List<SysUserDO> users = sysUserRepo.findByWxOpenid(openid);
//        if (users == null || users.isEmpty()) {
//            sysUserRepoProc.updateOpenidByUserName(openid, userName);
//            return ApiResult.ok(userName);
//        }
//        return ApiResult.fail("openid已经被绑定");
        return ApiResult.fail();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void batchSwitchUserStatus(SysUserBatchSwitchParam param) {
        if (CollectionUtils.isEmpty(param.getUserIds())) {
            return;
        }

        for (Long userId : param.getUserIds()) {
            userMngManager.updateEnabled(userId, param.isEnable());
        }
    }

    @Override
    public Set<SysRoleVO> listRolesByUsername(String username) {
        // 调用内部方法，缓存注解不会生效，不如走jpa方法，效率更高
        val user = sysUserRepo.findByUsername(username);
        if (user.isEmpty()) {
            return Collections.emptySet();
        }
//        return sysUserRoleService.listRolesByUserId(user.get().getId());
        return Collections.emptySet();
    }

    @Override
    public SysUserDTO current() {
        var details = SecurityContextUtil.currentUser();

        if (details != null) {
            return details.getUser();
        }

        return null;
    }

    @TenantTransaction(isolateType = TenantIsolateType.TENANT)
    @Override
    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {

        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(param.getRoleIds())) {
            var filterIds = param.getRoleIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
            var userIds = sysUserRepoProc.findUserIdsByRoleIds(filterIds);
            if (param.getUserIds() == null) {
                param.setUserIds(userIds);
            } else {
                param.getUserIds().addAll(userIds);
            }
        }

        return tenantDataIsolateProvider.byDefaultDirectly(() -> sysUserRepoProc.findRpcDtoByParam(param));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> idList) {
        sysUserRepoProc.delete(idList);
        for (Long id : idList) {
            expendUserServiceSpi(spi -> spi.afterUserDelete(id));
        }
    }

    /**
     * 获取默认密码
     * 1. 先从系统配置中获取默认密码
     * 2. 如果系统配置中没有配置默认密码，则默认密码为 123456
     * 3. 如果系统有配置默认密码，但是配置的默认密码为空，则报错
     *
     * @return 默认密码
     */
    private String generateDefaultPwd() {
        return userMngManager.getDefaultPassword();
    }

    /**
     * 随机生成密码
     *
     * @return 密码
     */
    private String generateRandomPwd() {
        return RandomUtil.randomString(8);
    }

    /**
     * 发送密码修改通知
     *
     * @param to           收件人
     * @param pwd          密码
     * @param transType    发送方式
     * @param templateCode 模版编号
     */
    private void sendPwdSmsNotify(String to, String pwd, String transType, String templateCode) {
        Map<String, Object> templateValues = new HashMap<>(2);
        templateValues.put("pwd", pwd);
        GeneralDubboCarrier carrier = GeneralDubboCarrier.builder()
                .tos(new String[]{to})
                .isRichContent(false)
                .transType(transType)
                .templateCode(templateCode)
                .templateValues(templateValues)
                .build();

        var response = msgCarrierDubboService.generalSend(Collections.singletonList(carrier));
        if (!response.isSuccess()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, response.getData().toString());
        }
    }
}
