package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataSelectorConverter;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorRespVO;
import com.elitescloud.cloudt.system.service.repo.DataSelectorGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
@Component
public class DataSelectorManager {

    @Autowired
    private DataSelectorRepoProc repoProc;
    @Autowired
    private DataSelectorGroupRepoProc groupRepoProc;

    public CommonDataSelectorRespVO getRespVO(@NotBlank String dataSelectorCode) {
        var selectorDO = repoProc.getByCode(dataSelectorCode);
        if (selectorDO == null || Boolean.FALSE.equals(selectorDO.getEnabled())) {
            return null;
        }

        var respVO = DataSelectorConverter.INSTANCE.do2CommonRespVO(selectorDO);

        if (StringUtils.hasText(respVO.getGroupCode())) {
            respVO.setGroupName(groupRepoProc.getNameByCode(respVO.getGroupCode()));
        }

        respVO.setApiHeaders(JSONUtil.json2Obj(selectorDO.getApiHeadersJson(), new TypeReference<HashMap<String, String>>() {
        }));
        respVO.setApiReqBody(JSONUtil.json2Obj(selectorDO.getApiReqBodyJson(), new TypeReference<HashMap<String, Object>>() {
        }));
        respVO.setApiReqParams(JSONUtil.json2Obj(selectorDO.getApiReqParamsJson(), new TypeReference<HashMap<String, String>>() {
        }));
        respVO.setDataFields(StringUtils.hasText(selectorDO.getDataFieldsStr()) ?
                Arrays.stream(selectorDO.getDataFieldsStr().split(",")).collect(Collectors.toList()) : Collections.emptyList());
        respVO.setExtAttributes(JSONUtil.json2Obj(selectorDO.getExtAttributesJson(), new TypeReference<HashMap<String, Object>>() {
        }));

        return respVO;
    }
}
