package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.BusinessRefBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectRefDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessObjectRefDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/7
 */
@Repository
public class BusinessObjectRefRepoProc extends BaseRepoProc<SysBusinessObjectRefDO> {
    private static final QSysBusinessObjectRefDO QDO = QSysBusinessObjectRefDO.sysBusinessObjectRefDO;

    public BusinessObjectRefRepoProc() {
        super(QDO);
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessObjectIds(long businessObjectId) {
        super.deleteByValue(QDO.businessObjectId, businessObjectId);
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByBusinessObjectIds(@NotEmpty Collection<Long> businessObjectIds) {
        super.deleteByValue(QDO.businessObjectId, businessObjectIds);
    }

    public List<SysBusinessObjectRefDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList(QDO.openApiCode.eq(openApiCode));
    }

    public List<BusinessRefBO> listSimpleBo() {
        return super.getList(this.qBeanSimpleBO(), null);
    }

    private QBean<BusinessRefBO> qBeanSimpleBO() {
        return Projections.bean(BusinessRefBO.class, QDO.id, QDO.businessObjectCode, QDO.refType, QDO.ref, QDO.sortNo);
    }
}
