package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataRelationCategoryDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataRelationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationCategoryDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Repository
public class DataRelationCategoryRepoProc extends BaseRepoProc<SysDataRelationCategoryDO> {
    private static final QSysDataRelationCategoryDO QDO = QSysDataRelationCategoryDO.sysDataRelationCategoryDO;
    private static final QSysDataRelationDO QDO_DR = QSysDataRelationDO.sysDataRelationDO;

    public DataRelationCategoryRepoProc() {
        super(QDO);
    }

    public void deleteByDrCode(@NotBlank String drCode) {
        super.deleteByValue(QDO.drCode, drCode);
    }

    public void deleteByDrIds(@NotEmpty Collection<Long> drIds) {
        jpaQueryFactory.delete(QDO)
                .where(QDO.drCode.in(
                        JPAExpressions.select(QDO_DR.code).from(QDO_DR).where(QDO_DR.id.in(drIds))
                ))
                .execute();
    }

    public boolean existsCode(@NotBlank String drCode, @NotBlank String code) {
        return super.exists(QDO.drCode.eq(drCode).and(QDO.catCode.eq(code)));
    }

    public List<String> getCodesByDrCode(@NotBlank String drCode) {
        return super.getValueListByValue(QDO.catCode, QDO.drCode, drCode);
    }

    public List<SysDataRelationCategoryDO> listByDrCode(@NotBlank String drCode) {
        return super.getListByValue(QDO.drCode, drCode, defaultOrder());
    }

    private OrderSpecifier<Integer> defaultOrder() {
        return QDO.sortNo.asc();
    }
}
