package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstValueBO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationInstSaveVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataRelationInstanceDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationInstanceDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Repository
public class DataRelationInstRepoProc extends BaseRepoProc<SysDataRelationInstanceDO> {
    private static final QSysDataRelationInstanceDO QDO = QSysDataRelationInstanceDO.sysDataRelationInstanceDO;

    public DataRelationInstRepoProc() {
        super(QDO);
    }

    public List<DataRelationInstValueBO> getValues(DataRelationInstQueryBO queryBO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.dataKey, queryBO.getDataKey())
                .andEq(QDO.dataAttribute, queryBO.getDataAttribute())
                .andEq(QDO.drCode, queryBO.getDrCode())
                .andEq(QDO.catCode, queryBO.getCatCode())
                .build();

        var qBean = Projections.bean(DataRelationInstValueBO.class, QDO.drCode, QDO.catCode, QDO.dataAttribute, QDO.dataAttribute, QDO.dataExtJson,
                QDO.refDataKey, QDO.refDataAttribute, QDO.refDataExtJson);
        return super.getList(qBean, predicate, defaultOrder());
    }

    public List<DataRelationInstValueBO> getValuesByRef(DataRelationInstQueryBO queryBO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.refDataKey, queryBO.getDataKey())
                .andEq(QDO.refDataAttribute, queryBO.getDataAttribute())
                .andEq(QDO.drCode, queryBO.getDrCode())
                .andEq(QDO.catCode, queryBO.getCatCode())
                .build();

        var qBean = Projections.bean(DataRelationInstValueBO.class, QDO.drCode, QDO.catCode, QDO.dataAttribute, QDO.dataAttribute, QDO.dataExtJson,
                QDO.refDataKey, QDO.refDataAttribute, QDO.refDataExtJson);
        return super.getList(qBean, predicate, defaultOrder());
    }

    public void deleteForInst(String drCode, Collection<String> dataKeyList) {
        var predicate = PredicateBuilder.builder()
                .andIn(QDO.dataKey, dataKeyList)
                .andEq(QDO.drCode, drCode)
                .build();
        super.delete(predicate);
    }

    private OrderSpecifier<Integer> defaultOrder() {
        return QDO.sortNo.asc();
    }
}
