package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupEmpDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
@Repository
public class EmpGroupRepoProc extends BaseRepoProc<SysEmpGroupDO> {
    private static final QSysEmpGroupDO QDO = QSysEmpGroupDO.sysEmpGroupDO;
    private static final QSysEmpGroupEmpDO QDO_GROUP_EMP = QSysEmpGroupEmpDO.sysEmpGroupEmpDO;

    public EmpGroupRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param id      ID
     * @param enabled 启用状态
     */
    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 判断编码是否已存在
     *
     * @param code 编码
     * @param id   ID
     * @return 是佛已存在
     */
    public boolean existsCode(String code, Long id) {
        return super.exists(QDO.code, code, id);
    }

    /**
     * 获取启用状态
     *
     * @param id id
     * @return 启用状态
     */
    public Boolean getEnabled(long id) {
        return super.getValue(QDO.enabled, id);
    }

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 员工组列表
     */
    public PagingVO<SysEmpGroupDO> pageMng(EmpGroupPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.type, queryVO.getType())
                .andLike(QDO.code, queryVO.getCode())
                .andLike(QDO.name, queryVO.getName())
                .andEq(QDO.enabled, queryVO.getEnabled())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public List<SysEmpGroupDO> listQuery(String type, Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.type, type)
                .andEq(QDO.enabled, enabled)
                .build();
        return super.getList(predicate, QDO.sortNo.asc());
    }

    public SysEmpGroupDTO getDtoByCode(@NotBlank String code) {
        return super.getOneByValue(qBeanDTO(), QDO.code, code);
    }

    public SysEmpGroupDTO getDto(long id) {
        return super.get(qBeanDTO(), id);
    }

    public List<SysEmpGroupDTO> getDtoList(Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.enabled, enabled)
                .build();
        return super.getList(qBeanDTO(), predicate, QDO.sortNo.asc());
    }

    private QBean<SysEmpGroupDTO> qBeanDTO() {
        return Projections.bean(SysEmpGroupDTO.class, QDO.id, QDO.code, QDO.name, QDO.enabled, QDO.sortNo);
    }
}
