package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleFieldPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDataPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleFieldPermissionDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@Repository
public class RoleFieldPermissionRepoProc extends BaseRepoProc<SysRoleFieldPermissionDO> {
    private static final QSysRoleFieldPermissionDO QDO = QSysRoleFieldPermissionDO.sysRoleFieldPermissionDO;

    public RoleFieldPermissionRepoProc() {
        super(QDO);
    }

    public void deleteByRole(String roleCode) {
        super.deleteByValue(QDO.roleCode, roleCode);
    }

    public void deleteByRoleForMenuOperation(@NotBlank String roleCode, @NotBlank String menuCode, @NotBlank String operationCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.menuCode.eq(menuCode)).and(QDO.operationCode.eq(operationCode))
                .and(QDO.permissionType.eq(DataPermissionType.MENU_OPERATION_RULE.name()));
        super.delete(predicate);
    }

    public void deleteByRoleForBusinessOperation(@NotBlank String roleCode, @NotBlank String operationCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.operationCode.eq(operationCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_OPERATION_RULE.name()));
        super.delete(predicate);
    }

    public void deleteByRoleForBusinessObject(@NotBlank String roleCode, @NotBlank String appCode, @NotBlank String businessObjectCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.businessObjectCode.eq(businessObjectCode)).and(QDO.appCode.eq(appCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_OBJECT_RULE.name()));
        super.delete(predicate);
    }

    public void deleteByRoleForBusinessObjectResource(@NotBlank String roleCode, @NotBlank String appCode, @NotBlank String businessObjectCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.businessObjectCode.eq(businessObjectCode)).and(QDO.appCode.eq(appCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_RESOURCE_RULE.name()));
        super.delete(predicate);
    }

    public List<SysRoleFieldPermissionDO> listByRoleForMenuOperation(@NotBlank String roleCode, @NotBlank String menuCode, @NotBlank String operationCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.menuCode.eq(menuCode)).and(QDO.operationCode.eq(operationCode))
                .and(QDO.permissionType.eq(DataPermissionType.MENU_OPERATION_RULE.name()));
        return super.getList(predicate);
    }

    public List<SysRoleFieldPermissionDO> listByRoleForBusinessOperation(@NotBlank String roleCode, @NotBlank String operationCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.operationCode.eq(operationCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_OPERATION_RULE.name()));
        return super.getList(predicate);
    }

    public List<SysRoleFieldPermissionDO> listByRoleForBusinessObject(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.businessObjectCode.eq(businessObjectCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_OBJECT_RULE.name()));
        return super.getList(predicate);
    }

    public List<SysRoleFieldPermissionDO> listByRoleForBusinessObjectResource(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        var predicate = QDO.roleCode.eq(roleCode).and(QDO.businessObjectCode.eq(businessObjectCode))
                .and(QDO.permissionType.eq(DataPermissionType.BUSINESS_RESOURCE_RULE.name()));
        return super.getList(predicate);
    }

    public List<SysRoleFieldPermissionDO> listByRole(@NotBlank String roleCode) {
        return super.getList(QDO.roleCode.eq(roleCode));
    }

    public List<SysDpcRoleApiFieldsDTO> queryByRoleCodes(@NotEmpty Collection<String> roleCode) {
        QBean<SysDpcRoleApiFieldsDTO> qBean = Projections.bean(SysDpcRoleApiFieldsDTO.class, QDO.id, QDO.roleCode, QDO.permissionType,
                QDO.appCode, QDO.menuCode.as("menusCode"), QDO.businessObjectCode, QDO.operationCode.as("apiPermissionCode"), QDO.fieldName,
                QDO.readable, QDO.writeable);

        return super.getList(qBean, QDO.roleCode.in(roleCode));
    }
}
