package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTmplImportFileDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplImportFileDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
@Repository
public class SysTmplImportFileRepoProc extends BaseRepoProc<SysTmplImportFileDO> {
    private static final QSysTmplImportFileDO QDO = QSysTmplImportFileDO.sysTmplImportFileDO;

    public SysTmplImportFileRepoProc() {
        super(QDO);
    }

    /**
     * 根据记录查询
     *
     * @param recordId
     * @return
     */
    public List<SysTmplImportFileDO> queryByRecordId(long recordId) {
        return super.getListByValue(QDO.recordId, recordId)
                .stream()
                .sorted(Comparator.comparingInt(t -> ObjectUtil.defaultIfNull(t.getFileOrder(), 0)))
                .collect(Collectors.toList());
    }

    /**
     * 根据记录查询
     *
     * @param recordId
     * @return
     */
    public List<String> queryFileCodeByRecordId(@NotNull Long recordId) {
        return super.jpaQueryFactory.select(QDO.fileCode)
                .from(QDO)
                .where(QDO.recordId.eq(recordId))
                .orderBy(QDO.fileOrder.asc())
                .fetch();
    }

    /**
     * 根据记录查询
     *
     * @param recordIds
     * @return
     */
    public Map<Long, List<String>> queryByRecordId(@NotEmpty Collection<Long> recordIds) {
        return super.jpaQueryFactory.select(QDO.recordId, QDO.fileCode, QDO.fileOrder)
                .from(QDO)
                .where(QDO.recordId.in(recordIds))
                .fetch()
                .stream()
                .collect(Collectors.groupingBy(t -> t.get(QDO.recordId), Collectors.collectingAndThen(
                        Collectors.toList(), t -> t.stream()
                                .sorted(Comparator.comparingInt(tt -> ObjectUtil.defaultIfNull(tt.get(QDO.fileOrder), 0)))
                                .map(tt -> tt.get(QDO.fileCode))
                                .collect(Collectors.toList())
                )));
    }
}
