package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import lombok.SneakyThrows;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:10
 * @Description:
 */
public class SpringUtils extends SpringUtil {
    /**
     * 类对象，是否在spring容器中存在
     *
     * @param clazz 类
     * @return 是否存在
     */
    public static <T> boolean isPresent(Class<T> clazz) {
        try {
            SpringUtil.getBean(clazz);
        } catch (NoSuchBeanDefinitionException e) {
            return false;
        }
        return true;
    }

    /**
     * 通过类路径获取 Bean
     *
     * @param <T>   对象类型
     * @param clazz 类名
     * @return Bean
     */
    @SneakyThrows
    @SuppressWarnings("unchecked")
    public static <T> T getClassBean(String clazz) {
        return (T) getBean(Class.forName(clazz));
    }
}
