package com.elitescloud.cloudt.ucenter.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */

@Data
@ApiModel(description = "网站外观配置信息表")
public class WebsiteAppearanceDTO implements Serializable  {

    private static final long serialVersionUID = -3338069957650787228L;

    @ApiModelProperty(value = "网站id")
    private Long id;

    @ApiModelProperty(value = "浏览器标题")
    private String title;

    @ApiModelProperty(value = "浏览器logo")
    private String browserLogoId;

    @ApiModelProperty(value = "网页logo")
    private String webpageLogoId;

    @ApiModelProperty(value = "网站主题色")
    private String themeColor;

    @ApiModelProperty(value = "字体大小")
    private Integer fontSize;

    @ApiModelProperty(value = "默认语言")
    private String language;

    @ApiModelProperty(value = "是否支持多语言")
    private Boolean multiLanguageFlag;

    @ApiModelProperty(value = "菜单是否展开")
    private Boolean menuUnfoldFlag;

    @ApiModelProperty(value = "菜单区域宽度")
    private Integer menuWidth;

    @ApiModelProperty(value = "网站描述")
    private String description;
}
