package com.elitescloud.cloudt.ucenter.api.vo.resp;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.ucenter.api.constant.ConstantsUcenter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(description = "广告信息出参")
@Data
public class AdInfoDetailRespVO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;

    @ApiModelProperty("广告id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("广告编码")
    private String adCode;

    @ApiModelProperty("广告标题")
    private String adTitle;

    @ApiModelProperty("广告位id")
    private Long adSpaceId;

    @ApiModelProperty("广告位code")
    private String adSpaceCode;

    @ApiModelProperty("广告位名称")
    private String adSpaceName;

    @ApiModelProperty("链接类型")
    @SysCode(sys = Application.NAME, mod = "LINK_TYPE")
    private String adLinkType;
    @ApiModelProperty("链接类型名称")
    private String adLinkTypeName;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @SysCode(sys = Application.NAME, mod = "SHOW_FLAG")
    private String showFlag;
    @ApiModelProperty(value = "是否显示名称")
    private String showFlagName;

    @ApiModelProperty("广告排序")
    private Integer sortNo;

    @ApiModelProperty("广告开始时间")
    private LocalDateTime showBeginTime;

    @ApiModelProperty("广告结束时间")
    private LocalDateTime showEndTime;

    @ApiModelProperty("目标类型")
    @SysCode(sys = Application.NAME, mod = "TARGET_TYPE")
    private String targetType;
    @ApiModelProperty("目标类型名称")
    private String targetTypeName;

    private Long linkAddressId;

    @ApiModelProperty("链接地址")
    private String linkAddress;

    @ApiModelProperty("广告图片文件编码")
    private String imgFileCode;

    @ApiModelProperty("视频文件code")
    private String videoFileCode;

    @ApiModelProperty("资源类型")
    @SysCode(sys = Application.NAME, mod = "SOURCE_TYPE")
    private String sourceType;
    @ApiModelProperty("资源类型名称")
    private String sourceTypeName;

    @ApiModelProperty("显示时间")
    private String showTime;

    @ApiModelProperty(value = "链接来源")
    private String linkSource;

    @ApiModelProperty("图片地址")
    private String imgUrl;

    @ApiModelProperty("视频地址")
    private String videoUrl;

    public String getShowTime() {
        if (ObjectUtil.isNotNull(showBeginTime) && ObjectUtil.isNotNull(showEndTime)) {
            return DateUtil.format(showBeginTime, ConstantsUcenter.TIME_FORMAT) + "~" +
                    DateUtil.format(showEndTime, ConstantsUcenter.TIME_FORMAT);
        } else {
            return "";
        }
    }

}
