CREATE TABLE `sys_openapi_info`
(
    `id`                                bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`                     varchar(255) DEFAULT NULL COMMENT 'OpenApi编码',
    `project`                           varchar(255) DEFAULT NULL COMMENT '项目编码',
    `project_name`                      varchar(255) DEFAULT NULL COMMENT '项目名称',
    `env`                               varchar(255) DEFAULT NULL COMMENT '环境编码',
    `env_name`                          varchar(255) DEFAULT NULL COMMENT '环境名称',
    `app_code`                          varchar(255) DEFAULT NULL COMMENT '应用编码',
    `app_name`                          varchar(255) DEFAULT NULL COMMENT '应用名称',
    `title`                             varchar(255) NOT NULL COMMENT '标题',
    `description`                       varchar(255) DEFAULT NULL COMMENT '描述',
    `version`                           varchar(255) DEFAULT NULL COMMENT '版本',
    `build_time`                        datetime(6)  DEFAULT NULL COMMENT 'OpenAPI构建时间',
    `project_version`                   varchar(255) DEFAULT NULL COMMENT '项目版本',
    `cloudt_boot_version`               varchar(255) DEFAULT NULL COMMENT '云梯架构版本',
    `resource_id`                       bigint       DEFAULT NULL COMMENT '原始数据的资源ID',
    `tags_json`                         longtext COMMENT '标签列表json',
    `state`                             varchar(255) DEFAULT NULL COMMENT 'OpenAPI状态',
    `fail_reason`                       longtext COMMENT 'OpenAPI更新失败原因',
    `start_update_time`                 datetime(6)  DEFAULT NULL COMMENT '开始更新时间',
    `end_update_time`                   datetime(6)  DEFAULT NULL COMMENT '结束更新时间',
    `business_object_state`             varchar(255) DEFAULT NULL COMMENT '业务对象状态',
    `business_object_fail_reason`       longtext COMMENT '业务对象更新失败原因',
    `business_object_start_update_time` datetime(6)  DEFAULT NULL COMMENT '开始更新时间',
    `business_object_end_update_time`   datetime(6)  DEFAULT NULL COMMENT '结束更新时间',
    `tenant_id`                         bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                     bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                     bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                            varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`                    bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                           varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                       datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                    bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                           varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                       datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                       int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`                int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                         bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                       bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                         bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_openapi_info_code` (`open_api_code`),
    KEY `idx_openapi_info_app` (`app_code`)
) COMMENT ='OpenAPI信息';
CREATE TABLE `sys_openapi_operation`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint       NOT NULL COMMENT 'openApi信息ID',
    `operation_code`     varchar(255) NOT NULL COMMENT '操作编码',
    `operation_id`       longtext COMMENT '操作ID',
    `summary`            varchar(255) DEFAULT NULL COMMENT '摘要信息',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tags_json`          longtext COMMENT '标签列表json',
    `resource_id`        bigint       DEFAULT NULL COMMENT '原始数据的资源ID',
    `business_operation` bit(1)       DEFAULT b'0' COMMENT '是否含有业务操作',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `url`                varchar(255) DEFAULT NULL COMMENT '接口地址',
    `method`             varchar(255) DEFAULT NULL COMMENT '接口方法',
    `data_source`        varchar(255) DEFAULT NULL COMMENT '数据来源',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_openapi_ope_code` (`operation_code`),
    KEY `idx_openapi_ope_info` (`open_api_info_id`),
    KEY `idx_openapi_ope_business` (`business_operation`),
    KEY `idx_openapi_ope_summary` (`summary`),
    KEY `idx_openapi_ope_url` (`url`)
) COMMENT ='OpenAPI操作信息';
CREATE TABLE `sys_openapi_tag`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint NOT NULL COMMENT 'openApi信息ID',
    `operation_id`       bigint       DEFAULT NULL COMMENT 'openApi操作ID',
    `tag`                varchar(255) DEFAULT NULL COMMENT 'tag内容',
    `sort_no`            int          DEFAULT '0' COMMENT '序号',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_tag_info` (`open_api_info_id`),
    KEY `idx_openapi_tag_opera` (`operation_id`),
    KEY `idx_openapi_tag_tag` (`tag`)
) COMMENT ='OpenAPI标签';
CREATE TABLE `sys_openapi_component_schema`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint       NOT NULL COMMENT 'openApi信息ID',
    `schema_path`        varchar(255) NOT NULL COMMENT 'schema名称',
    `schema_type`        varchar(255) DEFAULT NULL COMMENT 'schema类型',
    `resource_id`        bigint       DEFAULT NULL COMMENT '原始数据的资源ID',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_compsche_info` (`open_api_info_id`),
    KEY `idx_openapi_compsche_path` (`schema_path`)
) COMMENT ='OpenAPI操作信息参数';
CREATE TABLE `sys_openapi_resource`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint NOT NULL COMMENT 'openApi信息ID',
    `resource`           longtext COMMENT '资源内容字符串',
    `resource_byte`      longblob COMMENT '资源内容byte',
    `sort_no`            int          DEFAULT '0' COMMENT '排序',
    `ext1`               varchar(255) DEFAULT NULL COMMENT '扩展字段1',
    `ext2`               varchar(255) DEFAULT NULL COMMENT '扩展字段2',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_res_openapi` (`open_api_info_id`)
) COMMENT ='OpenAPI资源信息';

CREATE TABLE `sys_business_object`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_code`      varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `code`               varchar(255) DEFAULT NULL COMMENT '业务对象的编码',
    `name`               varchar(255) DEFAULT NULL COMMENT '业务对象的名称',
    `description`        varchar(255) DEFAULT NULL COMMENT '业务对象的描述',
    `domain`             varchar(255) DEFAULT NULL COMMENT '领域分类',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `data_source`        varchar(255) DEFAULT NULL COMMENT '数据来源',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_business_obj_key` (`open_api_code`, `code`),
    KEY `idx_business_obj_openapi` (`open_api_code`),
    KEY `idx_business_obj_app` (`app_code`),
    KEY `idx_business_obj_code` (`code`),
    KEY `idx_business_obj_domain` (`domain`)
) COMMENT ='业务对象';
CREATE TABLE `sys_business_operation`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`         varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_code`  varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_object_id`    bigint       NOT NULL COMMENT '业务对象ID',
    `app_code`              varchar(255) DEFAULT NULL COMMENT '应用编码',
    `operation_code`        varchar(255) NOT NULL COMMENT '操作编码',
    `operation_description` varchar(255) DEFAULT NULL COMMENT '操作描述',
    `operation_type`        varchar(255) DEFAULT NULL COMMENT '操作类型',
    `scope`                 varchar(255) DEFAULT NULL COMMENT '操作范围',
    `state`                 varchar(255) DEFAULT NULL COMMENT '操作状态',
    `display_type`          varchar(255) DEFAULT NULL COMMENT '显示类型',
    `display_style`         varchar(255) DEFAULT NULL COMMENT '显示样式',
    `display_condition`     varchar(255) DEFAULT NULL COMMENT '显示条件',
    `display_icon`          varchar(255) DEFAULT NULL COMMENT '显示图标',
    `display_order`         int          DEFAULT NULL COMMENT '显示顺序',
    `api_name`              varchar(255) DEFAULT NULL COMMENT 'API操作名称',
    `api_description`       varchar(255) DEFAULT NULL COMMENT 'API描述',
    `api_url`               varchar(255) DEFAULT NULL COMMENT 'API的URL',
    `api_method`            varchar(255) DEFAULT NULL COMMENT 'API的方法',
    `data_source`           varchar(255) DEFAULT NULL COMMENT '数据来源',
    `enabled`               bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_business_objopera_key` (`operation_code`),
    KEY `idx_business_objopera_openapi` (`open_api_code`),
    KEY `idx_business_objopera_busiobj` (`business_object_id`)
) COMMENT ='业务对象的操作';
CREATE TABLE `sys_business_operation_param`
(
    `id`                      bigint NOT NULL COMMENT '记录唯一ID',
    `business_object_id`      bigint NOT NULL COMMENT '业务对象ID',
    `business_object_code`    varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_operation_id`   bigint NOT NULL COMMENT '业务对象操作ID',
    `business_operation_code` varchar(255) DEFAULT NULL COMMENT '业务对象操作编码',
    `open_api_code`           varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `open_api_operation_code` varchar(255) DEFAULT NULL COMMENT 'OpenApi的操作编码',
    `field_name`              varchar(255) DEFAULT NULL COMMENT '字段名称',
    `field_description`       varchar(255) DEFAULT NULL COMMENT '字段描述',
    `request`                 bit(1)       DEFAULT b'1' COMMENT '是否为请求参数',
    `field_type`              varchar(255) DEFAULT NULL COMMENT '字段类型',
    `field_java_type`         varchar(255) DEFAULT NULL COMMENT '字段类型(java)',
    `ref`                     bit(1)       DEFAULT NULL COMMENT '是否有依赖',
    `ref_value`               varchar(255) DEFAULT NULL COMMENT '依赖地址',
    `depth`                   int          DEFAULT NULL COMMENT '参数深度',
    `param_path`              varchar(255) DEFAULT NULL COMMENT '参数路径',
    `api_result`              bit(1)       DEFAULT b'0' COMMENT '是否是ApiResult的参数',
    `required`                bit(1)       DEFAULT b'0' COMMENT '是否必须',
    `deprecated`              bit(1)       DEFAULT b'0' COMMENT '是否已过期',
    `param_in`                varchar(255) DEFAULT NULL COMMENT '参数位置',
    `single`                  bit(1)       DEFAULT b'0' COMMENT '是否是单值',
    `collection_type`         varchar(255) DEFAULT NULL COMMENT '集合类型',
    `data_source`             varchar(255) DEFAULT NULL COMMENT '数据来源',
    `enabled`                 bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`               bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`           bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`           bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                  varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`          bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                 varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`             datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`          bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                 varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`             datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`             int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`      int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`               bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`             bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`               bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_business_opera_param_openapi` (`open_api_code`),
    KEY `idx_business_opera_param_obj` (`business_object_id`),
    KEY `idx_business_opera_param_operation` (`business_operation_id`)
) COMMENT ='业务操作的参数';
CREATE TABLE `sys_business_param`
(
    `id`                          bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`               varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_id`          bigint       NOT NULL COMMENT '业务对象ID',
    `business_object_code`        varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_operation_id`       bigint       DEFAULT NULL COMMENT '业务操作ID',
    `business_operation_code`     varchar(255) DEFAULT NULL COMMENT '业务操作编码',
    `business_operation_param_id` bigint       DEFAULT NULL COMMENT '业务操作参数ID',
    `enabled`                     bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `entity_field`                bit(1)       DEFAULT b'0' COMMENT '是否为entity类的字段',
    `entity_class_name`           varchar(255) DEFAULT NULL COMMENT 'entity类的名称',
    `table_name`                  varchar(255) DEFAULT NULL COMMENT '表名',
    `field_name`                  varchar(255) NOT NULL COMMENT '字段名称',
    `column_name`                 varchar(255) DEFAULT NULL COMMENT '列名称',
    `field_description`           varchar(255) DEFAULT NULL COMMENT '字段描述',
    `field_java_type`             varchar(255) DEFAULT NULL COMMENT '字段类型(java)',
    `sort_no`                     int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`                   bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`               bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`               bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                      varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`              bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                     varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                 datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`              bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                     varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                 datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                 int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`          int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                   bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                 bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                   bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_business_param_openapi` (`open_api_code`),
    KEY `idx_business_param_obj` (`business_object_id`),
    KEY `idx_business_param_operation` (`business_operation_id`)
) COMMENT ='业务对象的参数';