CREATE TABLE `sys_menu_operation`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) NOT NULL COMMENT '菜单编码',
    `operation_code`     varchar(255) DEFAULT NULL COMMENT '业务操作编码',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_menu_operation_app` (`app_code`),
    KEY `idx_menu_operation_menu` (`menus_code`),
    KEY `idx_menu_operation_opera` (`operation_code`)
) COMMENT ='菜单与业务对象操作的关联';

CREATE TABLE `sys_role_data_permission`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `role_code`             varchar(255) NOT NULL COMMENT '角色编码',
    `permission_type`       varchar(255) NOT NULL COMMENT '权限类型',
    `app_code`              varchar(255) DEFAULT NULL COMMENT '应用编码',
    `menu_code`             varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `business_object_code`  varchar(255) DEFAULT NULL COMMENT '操作编码',
    `operation_code`        varchar(255) DEFAULT NULL COMMENT '操作编码',
    `rule_group_code`       varchar(255) DEFAULT NULL COMMENT '规则组编码',
    `rule_relation`         varchar(255) DEFAULT NULL COMMENT '规则关系',
    `rule_name`             varchar(255) DEFAULT NULL COMMENT '规则名称',
    `rule_order`            int          DEFAULT '0' COMMENT '规则排序',
    `rule_description`      varchar(255) DEFAULT NULL COMMENT '规则描述',
    `rule_field`            varchar(255) DEFAULT NULL COMMENT '规则字段',
    `rule_field_type`       varchar(255) DEFAULT NULL COMMENT '规则字段类型',
    `field_value_condition` varchar(255) DEFAULT NULL COMMENT '字段与值的关系',
    `rule_value_type`       varchar(255) DEFAULT NULL COMMENT '值类型',
    `rule_value`            varchar(255) DEFAULT NULL COMMENT '规则值',
    `rule_value_name`       varchar(255) DEFAULT NULL COMMENT '规则值名称',
    `data_set`              varchar(255) DEFAULT NULL COMMENT '数据集类型',
    `bs1`                   varchar(255) DEFAULT NULL COMMENT '特用字段1',
    `bs2`                   varchar(255) DEFAULT NULL COMMENT '特用字段2',
    `bs3`                   varchar(255) DEFAULT NULL COMMENT '特用字段3',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_role_datapermission_role` (`role_code`),
    KEY `idx_role_datapermission_type` (`permission_type`),
    KEY `idx_role_datapermission_opera` (`operation_code`)
) COMMENT ='角色与数据权限的关联';

alter table sys_role_permission
    add column role_code varchar(255) comment '角色编码';

alter table sys_business_param
    add column related_business_object varchar(255) comment '关联业务对象标识';
alter table sys_business_param
    add column related_field varchar(255) comment '关联业务对象字段';
create index idx_business_objopera_app on sys_business_operation (app_code);
create index idx_menu_app on sys_platform_menus (menus_app_code);
create index idx_menu_type on sys_platform_menus (menus_type);
create index idx_menu_nodetype on sys_platform_menus (node_type);
create index idx_role_datapermission_menu on sys_role_data_permission (menu_code);
create index idx_role_datapermission_obj on sys_role_data_permission (business_object_code);
create index idx_business_objopera_busiobjc on sys_business_operation (business_object_code);
create index idx_business_objopera_type on sys_business_operation (operation_type);
alter table sys_business_operation
    add column permission_enabled bit default 0 comment '是否启用权限';
create index idx_business_objopera_perms on sys_business_operation (permission_enabled);

CREATE TABLE `sys_business_object_ref`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`        varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_id`   bigint       NOT NULL COMMENT '业务对象ID',
    `business_object_code` varchar(255) NOT NULL COMMENT '业务对象编码',
    `ref`                  varchar(255) NOT NULL COMMENT '关联标识',
    `ref_type`             varchar(255) NOT NULL COMMENT '关联类型',
    `sort_no`              int                                DEFAULT '0' COMMENT '顺序',
    `data_source`          varchar(255)                       DEFAULT NULL COMMENT '数据来源',
    `tenant_id`            bigint                             DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint                             DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint                             DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255)                       DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint                             DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255)                       DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)                        DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint                             DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255)                       DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)                        DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int                                DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int                                DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint                             DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint                             DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint                             DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_business_obj_ref_objid` (`business_object_id`),
    KEY `idx_business_obj_ref_objc` (`business_object_code`),
    KEY `idx_business_obj_ref_ref` (`ref`),
    KEY `idx_business_obj_ref_openapi` (`open_api_code`)
) COMMENT ='业务对象的关联关系';
alter table sys_openapi_info add column business_resource_id bigint comment '业务对象的资源ID';
alter table sys_business_operation add column detail varchar(255) comment '详细描述' ;
alter table sys_business_param add column values_json longtext comment '值列表';
alter table sys_business_operation add column permission_ref varchar(255) comment '关联权限的业务操作编码';