CREATE TABLE `sys_notice`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `title`              varchar(255) NOT NULL COMMENT '标题',
    `summaries`          varchar(255) DEFAULT NULL COMMENT '摘要',
    `author_id`          bigint       DEFAULT NULL COMMENT '作者',
    `category`           varchar(255) DEFAULT NULL COMMENT '分类，[UDC]cloudt-system:noticeCategory',
    `notice_type`        varchar(255) DEFAULT NULL COMMENT '公告类型',
    `published`          bit(1)       DEFAULT b'0' COMMENT '是否已发布',
    `top`                bit(1)       DEFAULT b'0' COMMENT '是否置顶',
    `publish_time`       datetime     DEFAULT NULL COMMENT '发布时间',
    `change_time`        datetime     DEFAULT NULL COMMENT '修改时间',
    `txt_id`             bigint       DEFAULT NULL COMMENT '公告内容ID',
    `file_codes_str`     varchar(255) DEFAULT NULL COMMENT '附件标识，多个以逗号分隔',
    `read_amount`        bigint       DEFAULT '0' COMMENT '阅读量',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_notice_author` (`author_id`),
    KEY `idx_notice_publish` (`published`),
    KEY `idx_notice_publishtime` (`publish_time`),
    KEY `idx_notice_title` (`title`),
    KEY `idx_notice_category` (`category`),
    KEY `idx_notice_type` (`notice_type`)
) COMMENT ='系统公告';
CREATE TABLE `sys_notice_txt`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `notice_id`          bigint NOT NULL COMMENT '公告ID',
    `txt`                longtext COMMENT '公告内容',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_notice_txt_noticeid` (`notice_id`)
) COMMENT ='系统公告内容';
alter table sys_business_param add column deprecated bit default 0 comment '是否过期';