CREATE TABLE `sys_user_outerapp`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint       NOT NULL COMMENT '用户ID',
    `outer_app_id`       varchar(255) NOT NULL COMMENT '外部应用ID',
    `open_id`            varchar(255) NOT NULL COMMENT '外部应用的用户标识',
    `union_id`           varchar(255) DEFAULT NULL COMMENT '外部应用的用户标识2',
    `bind_time`          datetime(6)  DEFAULT NULL COMMENT '绑定时间',
    `tenant_code`        varchar(255) DEFAULT NULL COMMENT '租户编码',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_user_outerapp_key` (`user_id`, `open_id`, `outer_app_id`),
    KEY `idx_user_outerapp_user` (`user_id`),
    KEY `idx_user_outerapp_outerapp` (`outer_app_id`),
    KEY `idx_user_outerapp_openid` (`open_id`)
) ENGINE = InnoDB COMMENT ='用户角色关联表';