/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.comm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.convert.ComPaymentTermConvert;
import com.elitescloud.cloudt.comm.entity.ComPaymentTermDO;
import com.elitescloud.cloudt.comm.entity.QComPaymentTermDO;
import com.elitescloud.cloudt.comm.repo.ComPaymentTermRepo;
import com.elitescloud.cloudt.comm.repo.ComPaymentTermRepoProc;
import com.elitescloud.cloudt.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.comm.vo.save.ComPaymentTermSaveVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.cacheable.SysCachePaymentTermRpcService;
import com.elitescloud.cloudt.system.service.IComPaymentTermService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ComPaymentTermServiceImpl
implements IComPaymentTermService {
    private static final Logger log = LoggerFactory.getLogger(ComPaymentTermServiceImpl.class);
    private final ComPaymentTermRepo comPaymentTermRepo;
    private final ComPaymentTermRepoProc comPaymentTermRepoProc;
    @Autowired
    private SysCachePaymentTermRpcService cachePaymentTermRpcService;

    @Transactional(rollbackFor={Exception.class})
    public Long createOne(ComPaymentTermSaveVO paymentTerm) {
        paymentTerm.setId(null);
        List<ComPaymentTermSaveVO> comPaymentTermDOS = this.validDateProcessing(Collections.singletonList(paymentTerm));
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS.stream().map(ComPaymentTermConvert.INSTANCE::saveVOToDO).collect(Collectors.toList()));
        this.clearCache();
        return 0L;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> createBatch(List<ComPaymentTermSaveVO> list) {
        list.forEach(i -> i.setId(null));
        List<ComPaymentTermSaveVO> comPaymentTermDOS = this.validDateProcessing(list);
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS.stream().map(ComPaymentTermConvert.INSTANCE::saveVOToDO).collect(Collectors.toList()));
        this.clearCache();
        return Collections.EMPTY_LIST;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ComPaymentTermSaveVO paymentTerm) {
        if (!this.comPaymentTermRepo.existsById(paymentTerm.getId())) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<ComPaymentTermSaveVO> comPaymentTermDOS = this.validDateProcessing(Collections.singletonList(paymentTerm));
        this.comPaymentTermRepo.saveAll(comPaymentTermDOS.stream().map(ComPaymentTermConvert.INSTANCE::saveVOToDO).collect(Collectors.toList()));
        this.clearCache();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        if (!this.comPaymentTermRepo.existsById(id)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comPaymentTermRepo.deleteById(id);
        this.clearCache();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> paymentTermIdList) {
        ArrayList delList = new ArrayList();
        paymentTermIdList.forEach(i -> delList.add(new ComPaymentTermDO((Long)i){
            final /* synthetic */ Long val$i;
            {
                this.val$i = l;
                this.setId(this.val$i);
            }
        }));
        this.comPaymentTermRepo.deleteAll(delList);
        this.clearCache();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QComPaymentTermDO paymentTermDO = QComPaymentTermDO.comPaymentTermDO;
        BooleanExpression predicate = paymentTermDO.deleteFlag.isNull().or((Predicate)paymentTermDO.deleteFlag.eq((Object)0));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)paymentTermDO.id.eq((Object)id));
        Optional comPaymentTermDO = this.comPaymentTermRepo.findOne((Predicate)predicate);
        comPaymentTermDO.ifPresent(c -> {
            c.setDeleteFlag(1);
            this.comPaymentTermRepo.save(c);
        });
        this.clearCache();
    }

    public PagingVO<ComPaymentTermRespVO> search(ComPaymentTermQueryParamVO queryParam) {
        return this.comPaymentTermRepoProc.pageForMng(queryParam);
    }

    public ComPaymentTermRespVO getCodeOne(String code) {
        return this.findCodeOne(code).orElse(null);
    }

    public ComPaymentTermRespVO getIdOne(Long id) {
        return this.findIdOne(id).orElse(null);
    }

    public Optional<ComPaymentTermRespVO> findCodeOne(String paymentTermCode) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.eq((Object)paymentTermCode));
        return Optional.ofNullable((ComPaymentTermRespVO)jpaQuery.fetchOne());
    }

    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        if (paymentTermCodes == null || paymentTermCodes.isEmpty()) {
            return new ArrayList<ComPaymentTermRespVO>();
        }
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.in(paymentTermCodes));
        return jpaQuery.fetch();
    }

    public Optional<ComPaymentTermRespVO> findIdOne(Long paymentTermId) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.id.eq((Object)paymentTermId));
        return Optional.ofNullable((ComPaymentTermRespVO)jpaQuery.fetchOne());
    }

    public List<ComPaymentTermRespVO> findIdBatch(List<Long> idList) {
        return this.comPaymentTermRepo.findAllById(idList).stream().map(paymentTermDO -> {
            ComPaymentTermRespVO comPaymentTermVO = new ComPaymentTermRespVO();
            BeanUtils.copyProperties((Object)paymentTermDO, (Object)comPaymentTermVO);
            return comPaymentTermVO;
        }).collect(Collectors.toList());
    }

    public List<ComPaymentTermRespVO> list() {
        return this.comPaymentTermRepo.findAll().stream().map(ComPaymentTermConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public List<ComPaymentTermRpcDTO> findPaymentTermRpcDtoByParam(ComPaymentTermRpcDtoParam param) {
        return this.comPaymentTermRepoProc.findRpcDtoByParam(param);
    }

    private void clearCache() {
        this.cachePaymentTermRpcService.clearCache();
    }

    private List<ComPaymentTermSaveVO> validDateProcessing(List<ComPaymentTermSaveVO> paymentTermList) {
        List<ComPaymentTermSaveVO> result = Collections.synchronizedList(new ArrayList());
        paymentTermList.parallelStream().forEach(i -> {
            i.setValidFrom(LocalDateTime.of(i.getValidFrom().toLocalDate(), LocalTime.of(0, 0, 0)));
            i.setValidTo(LocalDateTime.of(i.getValidTo().toLocalDate(), LocalTime.of(23, 59, 59)));
        });
        paymentTermList.forEach(i -> {
            if (CharSequenceUtil.isBlank((CharSequence)i.getPtCode())) {
                throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u652f\u4ed8\u6761\u6b3e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!i.getValidFrom().isBefore(i.getValidTo())) {
                throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5728\u751f\u6548\u65e5\u671f\u4e4b\u524d");
            }
        });
        List ptCodes = paymentTermList.stream().map(ComPaymentTermSaveVO::getPtCode).distinct().collect(Collectors.toList());
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        List paymentTermVOList = ((JPAQuery)this.comPaymentTermRepoProc.select().where((Predicate)paymentTerm.ptCode.in(ptCodes))).fetch();
        if (CollectionUtils.isEmpty((Collection)paymentTermVOList)) {
            return paymentTermList;
        }
        for (ComPaymentTermSaveVO paymentTermDO : paymentTermList) {
            List<ComPaymentTermRespVO> paymentTermVOS = paymentTermVOList.stream().filter(i -> paymentTermDO.getPtCode().equals(i.getPtCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paymentTermVOS)) {
                result.add(paymentTermDO);
                continue;
            }
            List<ComPaymentTermSaveVO> validProcessList = this.getValidProcessList(paymentTermDO, paymentTermVOS);
            result.addAll(validProcessList);
        }
        return result;
    }

    private List<ComPaymentTermSaveVO> getValidProcessList(ComPaymentTermSaveVO newDO, List<ComPaymentTermRespVO> paymentTermVOS) {
        ArrayList<ComPaymentTermSaveVO> result = new ArrayList<ComPaymentTermSaveVO>();
        for (ComPaymentTermRespVO oldVO : paymentTermVOS) {
            ComPaymentTermSaveVO oldPaymentTerm;
            if (oldVO.getValidTo().isBefore(newDO.getValidFrom()) || oldVO.getValidFrom().isAfter(newDO.getValidTo())) continue;
            if (oldVO.getValidFrom().isBefore(newDO.getValidFrom())) {
                if (oldVO.getValidTo().isBefore(newDO.getValidTo()) || oldVO.getValidTo().isEqual(newDO.getValidTo())) {
                    ComPaymentTermSaveVO oldPaymentTermDO = new ComPaymentTermSaveVO();
                    BeanUtil.copyProperties((Object)oldVO, (Object)oldPaymentTermDO, (String[])new String[0]);
                    oldPaymentTermDO.setValidTo(LocalDateTime.of(LocalDate.from(newDO.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                    result.add(oldPaymentTermDO);
                    continue;
                }
                if (oldVO.getValidTo().isAfter(newDO.getValidTo())) {
                    ComPaymentTermSaveVO beforeOldPaymentTerm = new ComPaymentTermSaveVO();
                    ComPaymentTermSaveVO afterOldPaymentTerm = new ComPaymentTermSaveVO();
                    ComPaymentTermSaveVO oldPaymentTerm2 = new ComPaymentTermSaveVO();
                    BeanUtil.copyProperties((Object)oldVO, (Object)oldPaymentTerm2, (String[])new String[0]);
                    BeanUtil.copyProperties((Object)oldVO, (Object)beforeOldPaymentTerm, (String[])new String[0]);
                    BeanUtil.copyProperties((Object)oldVO, (Object)afterOldPaymentTerm, (String[])new String[0]);
                    beforeOldPaymentTerm.setValidTo(LocalDateTime.of(LocalDate.from(newDO.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                    afterOldPaymentTerm.setValidFrom(LocalDateTime.of(LocalDate.from(newDO.getValidTo().plusDays(1L)), LocalTime.MIN));
                    oldVO.setDeleteFlag(Integer.valueOf(1));
                    beforeOldPaymentTerm.setId(null);
                    afterOldPaymentTerm.setId(null);
                    oldPaymentTerm2.setDeleteFlag(Integer.valueOf(1));
                    result.add(oldPaymentTerm2);
                    result.add(beforeOldPaymentTerm);
                    result.add(afterOldPaymentTerm);
                    continue;
                }
            }
            if (!oldVO.getValidFrom().isAfter(newDO.getValidFrom()) && !oldVO.getValidFrom().isEqual(newDO.getValidFrom())) continue;
            if (oldVO.getValidTo().isBefore(newDO.getValidTo()) || oldVO.getValidTo().isEqual(newDO.getValidTo())) {
                oldPaymentTerm = new ComPaymentTermSaveVO();
                BeanUtil.copyProperties((Object)oldVO, (Object)oldPaymentTerm, (String[])new String[0]);
                oldPaymentTerm.setDeleteFlag(Integer.valueOf(1));
                result.add(oldPaymentTerm);
            }
            if (!oldVO.getValidTo().isAfter(newDO.getValidTo())) continue;
            oldPaymentTerm = new ComPaymentTermSaveVO();
            BeanUtil.copyProperties((Object)oldVO, (Object)oldPaymentTerm, (String[])new String[0]);
            oldPaymentTerm.setValidFrom(LocalDateTime.of(LocalDate.from(newDO.getValidTo().plusDays(1L)), LocalTime.MIN));
            result.add(oldPaymentTerm);
        }
        result.add(newDO);
        return result;
    }

    public ComPaymentTermServiceImpl(ComPaymentTermRepo comPaymentTermRepo, ComPaymentTermRepoProc comPaymentTermRepoProc) {
        this.comPaymentTermRepo = comPaymentTermRepo;
        this.comPaymentTermRepoProc = comPaymentTermRepoProc;
    }
}

