/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.customfield.service.impl;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.customfield.entity.CustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.entity.QCustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionSaveParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldQueryParam;
import com.elitescloud.cloudt.customfield.repositiory.CustomFieldDefinitionRepository;
import com.elitescloud.cloudt.customfield.service.CustomFieldDefinitionService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomFieldDefintionServiceImpl
implements CustomFieldDefinitionService {
    @Autowired
    private CustomFieldDefinitionRepository customFieldDefinitionRepository;

    @Transactional
    public ApiResult createCustomField(CustomFieldDefinitionSaveParam customFieldParam) {
        CustomFieldQueryParam customFieldQueryParam = new CustomFieldQueryParam();
        customFieldQueryParam.setBasicKey(customFieldParam.getBasicKey());
        customFieldQueryParam.setBasicModuleCode(customFieldParam.getBasicModuleCode());
        customFieldQueryParam.setBusinessObjectCode(customFieldParam.getBusinessObjectCode());
        Predicate predicate = CustomFieldDefinitionService.getPredicateByCustomFieldQueryParam(customFieldQueryParam);
        boolean exists = (Boolean)this.customFieldDefinitionRepository.findBy(predicate, fetchableFluentQuery -> fetchableFluentQuery.exists());
        if (exists) {
            return ApiResult.fail((String)"\u5b57\u6bb5key\u4e0d\u80fd\u91cd\u590d");
        }
        CustomFieldDefinitionDo customFieldDefinitionEntity = new CustomFieldDefinitionDo();
        BeanUtils.copyProperties((Object)customFieldParam, (Object)customFieldDefinitionEntity);
        customFieldDefinitionEntity.setBasicType(customFieldParam.getBasicType().name());
        this.customFieldDefinitionRepository.save(customFieldDefinitionEntity);
        return ApiResult.ok((Object)customFieldDefinitionEntity.getId());
    }

    @Override
    @Transactional
    public ApiResult<Long> deleteAndCreateCustomField(String businessObjectCode, List<CustomFieldDefinitionSaveParam> param) {
        this.customFieldDefinitionRepository.deleteByBusinessObjectCode(businessObjectCode);
        if (param != null) {
            for (CustomFieldDefinitionSaveParam customFieldDefinitionSaveParam : param) {
                this.createCustomField(customFieldDefinitionSaveParam);
            }
            return ApiResult.ok((Object)param.size());
        }
        return ApiResult.ok((Object)0L);
    }

    @Override
    public CustomFieldDefinitionDo getCustomFieldById(Long id) {
        return this.customFieldDefinitionRepository.findById(id).orElseGet(() -> null);
    }

    @Override
    public CustomFieldDefinitionDo getCustomFieldByCode(String code) {
        QCustomFieldDefinitionDo QDO = QCustomFieldDefinitionDo.customFieldDefinitionDo;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)QDO.basicModuleCode).eq(arg_0), (Object)code).getPredicate();
        CustomFieldDefinitionDo page = this.customFieldDefinitionRepository.findOne(predicate).orElseGet(() -> null);
        return page;
    }

    @Override
    @Transactional
    public ApiResult updateCustomField(Long id, CustomFieldDefinitionUpdateParam customFieldDetails) {
        CustomFieldDefinitionDo customField = (CustomFieldDefinitionDo)this.customFieldDefinitionRepository.findById(id).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5ID\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5 :: " + id));
        BeanUtils.copyProperties((Object)customFieldDetails, (Object)customField);
        this.customFieldDefinitionRepository.save(customField);
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public void deleteCustomField(Long id) {
        this.customFieldDefinitionRepository.deleteById(id);
    }

    @Override
    public PagingVO<CustomFieldDefinitionDo> searchCustomFields(CustomFieldQueryParam customFieldParam) {
        Predicate predicate = CustomFieldDefinitionService.getPredicateByCustomFieldQueryParam(customFieldParam);
        Page page = this.customFieldDefinitionRepository.findAll(predicate, (Pageable)customFieldParam.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.getContent());
        return pagingVo;
    }
}

