/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.groupitem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemConvert;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemDomainService;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemRepo;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemRepoProc;
import com.elitescloud.cloudt.system.dto.SysEmployeeGroupItemDTO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import com.elitescloud.cloudt.system.model.entity.SysEmployeeGroupItemDO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysEmployeeGroupItemDomainServiceImpl
implements SysEmployeeGroupItemDomainService {
    private static final Logger log = LoggerFactory.getLogger(SysEmployeeGroupItemDomainServiceImpl.class);
    private final SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo;
    private final SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc;

    @Override
    public PagingVO<SysEmployeeGroupItemPageRespVO> queryList(SysEmployeeGroupItemPageParamVO paramVO) {
        long count = this.sysEmployeeGroupItemRepoProc.countBy(paramVO);
        if (count > 0L) {
            List<SysEmployeeGroupItemPageRespVO> list = this.sysEmployeeGroupItemRepoProc.pageBy(paramVO);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public Optional<SysEmployeeGroupItemDTO> findById(Long id) {
        return this.sysEmployeeGroupItemRepo.findById(id).map(SysEmployeeGroupItemConvert.INSTANCE::doToDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(SysEmployeeGroupItemSaveVO saveVO) {
        if (saveVO.getId() == null) {
            SysEmployeeGroupItemDO sysEmployeeGroupItemDO = SysEmployeeGroupItemConvert.INSTANCE.saveVoToDO(saveVO);
            return ((SysEmployeeGroupItemDO)((Object)this.sysEmployeeGroupItemRepo.save((Object)sysEmployeeGroupItemDO))).getId();
        }
        Optional option = this.sysEmployeeGroupItemRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        SysEmployeeGroupItemDO sysEmployeeGroupItemDO = (SysEmployeeGroupItemDO)((Object)option.get());
        SysEmployeeGroupItemConvert.INSTANCE.copySaveParamToDo(saveVO, sysEmployeeGroupItemDO);
        return ((SysEmployeeGroupItemDO)((Object)this.sysEmployeeGroupItemRepo.save((Object)sysEmployeeGroupItemDO))).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.sysEmployeeGroupItemRepoProc.deleteByIds(ids);
    }

    @Override
    public List<SysEmployeeGroupItemRespVO> findByParam(SysEmployeeGroupItemParamVO paramVO) {
        return this.sysEmployeeGroupItemRepoProc.findByParam(paramVO);
    }

    public SysEmployeeGroupItemDomainServiceImpl(SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo, SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc) {
        this.sysEmployeeGroupItemRepo = sysEmployeeGroupItemRepo;
        this.sysEmployeeGroupItemRepoProc = sysEmployeeGroupItemRepoProc;
    }
}

