/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.groupitem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemConvert;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemDomainService;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemRepo;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemRepoProc;
import com.elitescloud.cloudt.groupitem.SysEmployeeGroupItemService;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveHeadVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysEmployeeGroupItemServiceImpl
implements SysEmployeeGroupItemService {
    private static final Logger log = LoggerFactory.getLogger(SysEmployeeGroupItemServiceImpl.class);
    private final SysEmployeeGroupItemDomainService sysEmployeeGroupItemDomainService;
    private final SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo;
    private final SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<SysEmployeeGroupItemPageRespVO> page(SysEmployeeGroupItemPageParamVO paramVO) {
        return this.sysEmployeeGroupItemDomainService.queryList(paramVO);
    }

    @Override
    @SysCodeProc
    public Optional<SysEmployeeGroupItemRespVO> findById(Long id) {
        return this.sysEmployeeGroupItemDomainService.findById(id).map(SysEmployeeGroupItemConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(SysEmployeeGroupItemSaveHeadVO saveVO) {
        if (saveVO.getEmployeeGroupId() == null) {
            throw new BusinessException("\u5458\u5de5\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = saveVO.getItemList();
        if (list == null || list.isEmpty()) {
            throw new BusinessException("\u5458\u5de5\u7ec4\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysEmployeeGroupItemParamVO sysEmployeeGroupItemParamVO = new SysEmployeeGroupItemParamVO();
        sysEmployeeGroupItemParamVO.setEmployeeGroupId(saveVO.getEmployeeGroupId());
        List<SysEmployeeGroupItemRespVO> sysEmployeeGroupItemRespVOS = this.sysEmployeeGroupItemDomainService.findByParam(sysEmployeeGroupItemParamVO);
        for (SysEmployeeGroupItemSaveVO item : list) {
            boolean flag = true;
            if (sysEmployeeGroupItemRespVOS != null && !sysEmployeeGroupItemRespVOS.isEmpty()) {
                for (SysEmployeeGroupItemRespVO vo : sysEmployeeGroupItemRespVOS) {
                    if (!item.getItemScopeCode().equals(vo.getItemScopeCode()) || !item.getItemScopeType().equals(vo.getItemScopeType())) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            this.sysEmployeeGroupItemDomainService.save(item);
        }
        return list.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.sysEmployeeGroupItemDomainService.deleteByIds(ids);
    }

    public SysEmployeeGroupItemServiceImpl(SysEmployeeGroupItemDomainService sysEmployeeGroupItemDomainService, SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo, SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc) {
        this.sysEmployeeGroupItemDomainService = sysEmployeeGroupItemDomainService;
        this.sysEmployeeGroupItemRepo = sysEmployeeGroupItemRepo;
        this.sysEmployeeGroupItemRepoProc = sysEmployeeGroupItemRepoProc;
    }
}

