/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.log.config;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.log.config.LogStashProperties;
import com.elitescloud.cloudt.log.config.SwaggerLogStashConfig;
import com.elitescloud.cloudt.log.service.LogStashService;
import com.elitescloud.cloudt.log.service.impl.LogStashServiceFilebeat;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.logstash", name={"enabled"}, havingValue="true")
@ConditionalOnClass(value={RestHighLevelClient.class})
@EnableConfigurationProperties(value={LogStashProperties.class})
@Import(value={SwaggerLogStashConfig.class})
public class LogStashAutoConfiguration {
    @Bean
    public LogStashService logStashService(LogStashProperties logStashProperties) {
        HttpHost[] httpHosts = (HttpHost[])((List)Assert.notEmpty(logStashProperties.getElasticsearchUris(), (String)"", (Object[])new Object[0])).stream().map(this::convertHttpHost).toArray(HttpHost[]::new);
        RestClientBuilder restClient = RestClient.builder((HttpHost[])httpHosts);
        return new LogStashServiceFilebeat(new RestHighLevelClient(restClient), (String)Assert.notBlank((CharSequence)logStashProperties.getLogGroup(), (String)"\u65e5\u5fd7\u6240\u5728\u7ec4\u4e3a\u7a7a", (Object[])new Object[0]));
    }

    private HttpHost convertHttpHost(String url) {
        String[] array = url.split(":");
        String scheme = array[0];
        String ip = array[1].substring(2);
        int port = Integer.parseInt(array[2]);
        return new HttpHost(ip, port, scheme);
    }
}

