/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.service.UserMngService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class SystemLoginCallback
implements AuthenticationCallable {
    private static final Logger log = LoggerFactory.getLogger(SystemLoginCallback.class);
    private final UserMngService userMngService;

    public SystemLoginCallback(UserMngService userMngService) {
        this.userMngService = userMngService;
    }

    public void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
        GeneralUserDetails user;
        GeneralUserDetails generalUserDetails = user = authentication.getPrincipal() instanceof GeneralUserDetails ? (GeneralUserDetails)authentication.getPrincipal() : null;
        if (user == null) {
            return;
        }
        CompletableFuture.runAsync(() -> this.userMngService.updateLastLoginTime(user.getUserId(), user.getTenantId(), LocalDateTime.now())).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u8bb0\u5f55\u767b\u5f55\u65e5\u5fd7\u5f02\u5e38\uff1a", e);
            }
        });
    }
}

