/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.cas.common.PwdRecordTypeEnum;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdUpdateDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.model.UpdaterInfoDTO;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.cas.BaseCasClientService;
import com.elitescloud.cloudt.system.service.IUserService;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

class UserChangedCallbackCas
extends BaseCasClientService
implements UserChangedCallback {
    private static final Logger log = LogManager.getLogger(UserChangedCallbackCas.class);
    private final UserTransferHelper userTransferHelper;
    private final AuthorizationSdkProperties sdkProperties;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private IUserService userService;

    public UserChangedCallbackCas(AuthorizationSdkProperties sdkProperties, UserTransferHelper userTransferHelper) {
        this.userTransferHelper = userTransferHelper;
        this.sdkProperties = sdkProperties;
    }

    public void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            AuthUserDTO dto = super.do2Dto(userDO, saveBO.getPassword());
            UpdaterInfoDTO updaterInfoDTO = this.createUpdaterInfo(request, null);
            dto.setUpdaterInfo(updaterInfoDTO);
            Result syncResult = this.userTransferHelper.upsertUser(dto);
            if (!syncResult.getSuccess().booleanValue() || syncResult.getData() == null) {
                log.error("CAS\u540c\u6b65\u7528\u6237\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)syncResult);
                throw new BusinessException(CharSequenceUtil.blankToDefault((CharSequence)syncResult.getMsg(), (String)"\u521b\u5efa\u8d26\u53f7\u5931\u8d25"));
            }
            if (ObjectUtil.equals((Object)userDO.getCasUserId(), (Object)syncResult.getData())) {
                return null;
            }
            this.userService.updateCasSyncResult(Map.of(userDO.getUsername(), (Long)syncResult.getData()));
            return null;
        });
    }

    public void onEnabled(Long userId, boolean enabled) {
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            Long id = this.userRepoProc.getCasUserId(userId);
            if (id == null) {
                return null;
            }
            Boolean userEnabled = this.userRepoProc.getEnabled(userId);
            this.userTransferHelper.updateEnabled(id.longValue(), ((Boolean)ObjectUtil.defaultIfNull((Object)userEnabled, (Object)false)).booleanValue());
            return null;
        });
    }

    public void onUpdatePassword(Long userId, String password, String originalPassword) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            Long id = this.userRepoProc.getCasUserId(userId);
            if (id == null) {
                return null;
            }
            AuthPwdUpdateDTO updateDTO = new AuthPwdUpdateDTO();
            updateDTO.setUserId(id);
            updateDTO.setPassword(password);
            GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
            if (currentUser == null) {
                updateDTO.setUpdateType(PwdRecordTypeEnum.RETRIEVE);
            } else if (currentUser.getUserId().longValue() == userId.longValue()) {
                updateDTO.setUpdateType(PwdRecordTypeEnum.UPDATE);
            } else {
                updateDTO.setUpdateType(PwdRecordTypeEnum.RESET);
            }
            UpdaterInfoDTO updaterInfoDTO = this.createUpdaterInfo(request, currentUser);
            updateDTO.setUpdaterInfo(updaterInfoDTO);
            this.userTransferHelper.updatePwd(updateDTO);
            return null;
        });
    }

    public void onUpdateMobile(Long userId, String mobile) {
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            Long id = this.userRepoProc.getCasUserId(userId);
            if (id == null) {
                return null;
            }
            this.userTransferHelper.updateMobile(id.longValue(), mobile);
            return null;
        });
    }

    public void onUpdateEmail(Long userId, String email) {
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            Long id = this.userRepoProc.getCasUserId(userId);
            if (id == null) {
                return null;
            }
            this.userTransferHelper.updateEmail(id.longValue(), email);
            return null;
        });
    }

    public void onDelete(Long userId, Long casUserId) {
        this.execute(() -> {
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)this.sdkProperties.getCasClient().getEnabled(), (Object)false)).booleanValue()) {
                return null;
            }
            if (casUserId == null) {
                return null;
            }
            boolean userExists = this.userRepoProc.exists(userId);
            if (userExists) {
                return null;
            }
            this.userTransferHelper.delete(casUserId.longValue());
            return null;
        });
    }

    private UpdaterInfoDTO createUpdaterInfo(HttpServletRequest request, GeneralUserDetails currentUser) {
        if (request == null) {
            request = HttpServletUtil.currentRequest();
        }
        if (currentUser == null) {
            currentUser = SecurityContextUtil.currentUser();
        }
        UpdaterInfoDTO updaterInfoDTO = new UpdaterInfoDTO();
        if (currentUser != null) {
            updaterInfoDTO.setUpdaterId(currentUser.getUser().getCasUserId());
            updaterInfoDTO.setUpdater(currentUser.getUser().getUsername());
        }
        if (request != null) {
            updaterInfoDTO.setIp(HttpServletUtil.currentClientIp());
            updaterInfoDTO.setBrowserAgent(request.getHeader("User-Agent"));
        }
        return updaterInfoDTO;
    }

    private <T> void execute(Supplier<T> supplier) {
        supplier.get();
    }
}

