/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.businessobject;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessObjectPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.QueryBusinessOperationParam;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessOperationPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessOperationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessPermissionParamRespVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessObjectSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessOperationSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.UpdateFieldPermissionFilterParam;
import com.elitescloud.cloudt.system.service.BusinessObjectMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u5bf9\u8c61\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/businessObject"}, produces={"application/json"})
@Validated
public class BusinessObjectMngController {
    private BusinessObjectMngService service;

    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u64cd\u4f5c\u7684\u53c2\u6570")
    @PostMapping(value={"/businessOperationParam/queryByOpenApiCode"})
    public ApiResult<List<BusinessOperationParamBO>> queryBusinessOperationParam(@RequestBody QueryBusinessOperationParam queryBusinessOperationParam) {
        ApiResult<List<BusinessOperationParamBO>> paramBOList = this.service.queryBusinessOperationParam(queryBusinessOperationParam.getOpenApiCode(), queryBusinessOperationParam.getParamInEnum());
        return paramBOList;
    }

    @ApiOperation(value="\u4fee\u6539\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u53c2\u6570 \u662f\u5426\u6743\u9650\u8fc7\u6ee4")
    @PutMapping(value={"/businessOperationParam/updateFieldPermissionFilter"})
    public ApiResult<Boolean> updateFieldPermissionFilter(@RequestBody UpdateFieldPermissionFilterParam param) {
        return this.service.updateBusinessOperationFieldPermissionFilter(param);
    }

    @ApiOperation(value="\u3010\u6d4b\u8bd5\u3011\u6d4b\u8bd5OpenApi\u8f6cBusinessObject")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="openApiId", value="openApiId"), @ApiImplicitParam(name="openApiOperationId", value="\u64cd\u4f5cID"), @ApiImplicitParam(name="save", value="\u662f\u5426\u4fdd\u5b58")})
    @GetMapping(value={"/testAnalyze"})
    public ApiResult<Boolean> testAnalyze(@RequestParam(name="openApiId") Long openApiId, @RequestParam(name="openApiOperationId", required=false) Long openApiOperationId, @RequestParam(name="save", required=false, defaultValue="false") Boolean save) throws Exception {
        return this.service.testAnalyzeOpenApi(openApiId, openApiOperationId, save);
    }

    @ApiOperation(value="\u6839\u636eOpenApiId\u751f\u6210")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="openApiId", value="openApiId", required=true)
    @PostMapping(value={"/generateByOpenApi"})
    public ApiResult<Long> generateByOpenApi(@RequestParam(name="openApiId") @NotNull(message="OpenApiId") @NotNull(message="OpenApiId") Long openApiId) {
        return this.service.generateByOpenApi(openApiId);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u5bf9\u8c61")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/pageBusinessObject"})
    public ApiResult<PagingVO<BusinessObjectPageRespVO>> pageMng(@RequestBody BusinessObjectPageQueryVO queryVO) {
        return this.service.pageObject(queryVO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody @Valid BusinessObjectSaveVO saveVO) {
        return this.service.saveBusinessObject(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61ID", required=true, dataType="long")
    @GetMapping(value={"/detail"})
    public ApiResult<BusinessObjectDetailRespVO> getDetail(@RequestParam(name="id") @NotNull(message="ID\u4e3a\u7a7a") @NotNull(message="ID\u4e3a\u7a7a") Long id) {
        return this.service.getDetail(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u64cd\u4f5c\u4fe1\u606f")
    @ApiOperationSupport(order=11)
    @ApiImplicitParam(name="operationId", value="\u4e1a\u52a1\u5bf9\u8c61\u7684\u64cd\u4f5cID", required=true, dataType="long")
    @GetMapping(value={"/operation"})
    public ApiResult<BusinessOperationRespVO> getBusinessOperation(@RequestParam(name="operationId") @NotNull(message="\u64cd\u4f5cID\u4e3a\u7a7a") @NotNull(message="\u64cd\u4f5cID\u4e3a\u7a7a") Long operationId) {
        return this.service.getBusinessOperation(operationId);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u64cd\u4f5c")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/pageBusinessOperation"})
    public ApiResult<PagingVO<BusinessOperationPageRespVO>> pageMng(@RequestBody BusinessOperationPageQueryVO queryVO) {
        return this.service.pageOperation(queryVO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u64cd\u4f5c\u4fe1\u606f")
    @ApiOperationSupport(order=13)
    @PostMapping(value={"/operation/save"})
    public ApiResult<Long> save(@RequestBody @Valid BusinessOperationSaveVO saveVO) {
        return this.service.saveBusinessOperation(saveVO);
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u4e1a\u52a1\u64cd\u4f5c\u4fe1\u606f")
    @ApiOperationSupport(order=13)
    @PostMapping(value={"/operation/save/batch"})
    public ApiResult<Set<Long>> save(@RequestBody @Valid List<BusinessOperationSaveVO> saveVO) {
        return this.service.saveBusinessOperation(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u7684\u6743\u9650\u5b57\u6bb5")
    @ApiOperationSupport(order=21)
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61ID", required=true, dataType="long")
    @GetMapping(value={"/permissionField"})
    public ApiResult<List<BusinessPermissionParamRespVO>> getPermissionField(@RequestParam(name="id") @NotNull(message="\u4e1a\u52a1\u5bf9\u8c61ID\u4e3a\u7a7a") @NotNull(message="\u4e1a\u52a1\u5bf9\u8c61ID\u4e3a\u7a7a") Long id) {
        return this.service.listPermissionFields(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u64cd\u4f5c\u7684\u6743\u9650\u5b57\u6bb5")
    @ApiOperationSupport(order=22)
    @ApiImplicitParam(name="operationId", value="\u4e1a\u52a1\u5bf9\u8c61\u7684\u64cd\u4f5cID", required=true, dataType="long")
    @GetMapping(value={"/operation/permissionField"})
    public ApiResult<List<BusinessPermissionParamRespVO>> getOperationPermissionField(@RequestParam(name="operationId") @NotNull(message="\u64cd\u4f5cID\u4e3a\u7a7a") @NotNull(message="\u64cd\u4f5cID\u4e3a\u7a7a") Long operationId) {
        return this.service.listOperationPermissionFields(operationId);
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5b57\u6bb5\u7684\u662f\u5426\u652f\u6301\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=31)
    @ApiImplicitParams(value={@ApiImplicitParam(name="paramId", value="\u4e1a\u52a1\u53c2\u6570ID", required=true, dataType="long"), @ApiImplicitParam(name="enabled", value="\u662f\u5426\u542f\u7528", dataType="boolean")})
    @PatchMapping(value={"/param/dataPermission"})
    public ApiResult<Long> updateParamDataPermission(@RequestParam(name="paramId") @NotNull(message="\u53c2\u6570ID\u4e3a\u7a7a") @NotNull(message="\u53c2\u6570ID\u4e3a\u7a7a") Long paramId, @RequestParam(name="enabled", required=false, defaultValue="false") Boolean enabled) {
        return this.service.updateDataPermissionEnabledOfParam(paramId, enabled);
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5b57\u6bb5\u7684\u662f\u5426\u652f\u6301\u5b57\u6bb5\u6743\u9650")
    @ApiOperationSupport(order=33)
    @ApiImplicitParams(value={@ApiImplicitParam(name="paramId", value="\u4e1a\u52a1\u53c2\u6570ID", required=true, dataType="long"), @ApiImplicitParam(name="enabled", value="\u662f\u5426\u542f\u7528", dataType="boolean")})
    @PatchMapping(value={"/param/fieldPermission"})
    public ApiResult<Long> updateParamFieldPermission(@RequestParam(name="paramId") @NotNull(message="\u53c2\u6570ID\u4e3a\u7a7a") @NotNull(message="\u53c2\u6570ID\u4e3a\u7a7a") Long paramId, @RequestParam(name="enabled", required=false, defaultValue="false") Boolean enabled) {
        return this.service.updateFieldPermissionEnabledOfParam(paramId, enabled);
    }

    @Autowired
    public void setService(BusinessObjectMngService service) {
        this.service = service;
    }
}

