/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.CommonTenantAppVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAppPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRateQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataRelationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.OuterAppSettingRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;
import com.elitescloud.cloudt.system.service.SystemQueryService;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@BusinessObject(businessType="Sys_Common:\u516c\u5171")
@Api(tags={"\u901a\u7528\u7cfb\u7edf\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/mng/common/system"}, produces={"application/json"})
@Validated
public class CommonSystemController {
    private final SystemQueryService systemQueryService;

    public CommonSystemController(SystemQueryService systemQueryService) {
        this.systemQueryService = systemQueryService;
    }

    @ApiOperation(value="\u5e94\u7528\u5217\u8868")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="outerApp", value="\u662f\u5426\u5916\u90e8\u5e94\u7528"), @ApiImplicitParam(name="authed", value="\u662f\u5426\u9700\u8981\u6388\u6743")})
    @GetMapping(value={"/apps"})
    public ApiResult<List<CommonTenantAppVO>> listApp(@RequestParam(value="outerApp", required=false) Boolean outerApp, @RequestParam(value="authed", required=false) Boolean authed) {
        return this.systemQueryService.listApp(outerApp, authed);
    }

    @ApiOperation(value="\u5e94\u7528\u5206\u9875\u5217\u8868")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/apps/page"})
    public ApiResult<PagingVO<CommonTenantAppVO>> pageApp(@RequestBody CommonAppPageQueryVO queryVO) {
        return this.systemQueryService.pageApp(queryVO);
    }

    @ApiOperation(value="\u8d27\u5e01\u5217\u8868")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/currency"})
    public ApiResult<List<CodeNameParam>> listCurrency() {
        return this.systemQueryService.listCurrency();
    }

    @ApiOperation(value="\u7a0e\u7387\u5217\u8868")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="taxRateNo", value="\u7a0e\u7387\u7f16\u7801"), @ApiImplicitParam(name="taxRateType", value="\u7a0e\u7387\u7c7b\u578b, UDC[cloudt-system:taxRateType]")})
    @GetMapping(value={"/taxRate"})
    public ApiResult<List<CommonTaxRateRespVO>> listTaxRate(@RequestParam(name="taxRateNo", required=false) String taxRateNo, @RequestParam(name="taxRateType", required=false) String taxRateType) {
        return this.systemQueryService.listTaxRate(taxRateNo, taxRateType);
    }

    @ApiOperation(value="\u67e5\u8be2\u6c47\u7387")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/currencyRatio"})
    public ApiResult<Double> findTaxRate(@RequestBody @Valid CurrencyRateQueryVO queryVO) {
        return this.systemQueryService.queryCurrentRate(queryVO);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u57df\u5217\u8868")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/area"})
    public ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaQueryVO queryVO) {
        return this.systemQueryService.listArea(queryVO);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u57df\u6811\u5217\u8868")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/area/tree"})
    public ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaTreeQueryVO queryVO) {
        return this.systemQueryService.treeArea(queryVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5bc6\u7801\u7b56\u7565")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/pwdStrategy"})
    public ApiResult<List<PwdStrategyRespVO>> listStrategy() {
        return this.systemQueryService.listPwdStrategyForCreateAccount();
    }

    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u5e94\u7528\u8bbe\u7f6e")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/outerAppSettings"})
    public ApiResult<List<OuterAppSettingRespVO>> listOuterAppSettings() {
        return this.systemQueryService.listOuterAppSettings();
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u9009\u62e9\u5668")
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/dataSelector/tree"})
    public ApiResult<List<CommonDataSelectorListRespVO>> listTree(@RequestParam(name="tree", required=false) Boolean tree) {
        return this.systemQueryService.listTree(tree);
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u67e5\u8be2\u88ab\u5173\u8054\u6570\u636e")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/dataRelation"})
    public ApiResult<List<CommonDataRelationRespVO>> queryRelation(@RequestBody CommonDataRelationQueryVO queryVO) {
        return this.systemQueryService.queryRelation(queryVO);
    }

    @ApiOperation(value="\u6839\u636e\u88ab\u5173\u8054\u7684\u6570\u636e\u67e5\u8be2\u6570\u636e")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/dataRelation/ref"})
    public ApiResult<List<CommonDataRelationRespVO>> queryRelationByRef(@RequestBody CommonDataRelationQueryVO queryVO) {
        return this.systemQueryService.queryRelationByRefData(queryVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2UDC")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/udc/page"})
    public ApiResult<PagingVO<UdcWithValuesPageRespVO>> pageQuery(@RequestBody UdcPageQueryVO queryVO) {
        return this.systemQueryService.pageQueryUdc(queryVO);
    }
}

