/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertSendSaveVO;
import com.elitescloud.cloudt.system.service.SysAlertMngService;
import com.elitescloud.cloudt.system.service.SysAlertService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u8b66\u914d\u7f6e\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/alert"}, produces={"application/json"})
@Validated
public class AlertMngController {
    private SysAlertMngService service;
    private SysAlertService alertService;

    @GetMapping(value={"/getTmplParam"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u53c2\u6570")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="businessType", value="\u4e1a\u52a1\u7c7b\u578b", required=true)
    public ApiResult<List<CodeNameParam>> getTmplParam(@RequestParam(value="businessType") String businessType) {
        return this.service.getTmplParam(businessType);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u9884\u8b66\u914d\u7f6e")
    @ApiOperationSupport(order=1)
    public ApiResult<Long> save(@RequestBody @Valid AlertSaveVO saveVO) {
        return this.service.saveAlert(saveVO);
    }

    @GetMapping(value={"/get"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u9884\u8b66\u914d\u7f6e")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="businessType", value="\u4e1a\u52a1\u7c7b\u578b", required=true)
    public ApiResult<AlertRespVO> get(@RequestParam(value="businessType") String businessType) {
        return this.service.getAlert(businessType);
    }

    @PostMapping(value={"/test/send"})
    @ApiOperation(value="\u6d4b\u8bd5\u9884\u8b66\u53d1\u9001")
    @ApiOperationSupport(order=3)
    public ApiResult<Boolean> testSend(@RequestBody @Valid AlertSendSaveVO sendSaveVO) {
        if (CharSequenceUtil.isNotBlank((CharSequence)sendSaveVO.getContent())) {
            return this.alertService.sendAlert(sendSaveVO.getBusinessType(), sendSaveVO.getCategory(), sendSaveVO.getContent());
        }
        if (CollUtil.isNotEmpty(sendSaveVO.getTmplParams())) {
            return this.alertService.sendAlertByTmpl(sendSaveVO.getBusinessType(), sendSaveVO.getCategory(), sendSaveVO.getTmplParams());
        }
        return ApiResult.fail((String)"\u53d1\u9001\u5185\u5bb9\u548c\u6a21\u677f\u53c2\u6570\u81f3\u5c11\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
    }

    @Autowired
    public void setService(SysAlertMngService service) {
        this.service = service;
    }

    @Autowired
    public void setAlertService(SysAlertService alertService) {
        this.alertService = alertService;
    }
}

