/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.CurrencyRateCalcMethod;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.CurrencyRateSaveVO;
import com.elitescloud.cloudt.system.service.CurrencyRateMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysCurrencyRateDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6c47\u7387\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/currencyRate"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_CurrencyRate:\u6c47\u7387", businessDoClass=SysCurrencyRateDO.class)
public class CurrencyRateController {
    private final CurrencyRateMngService service;

    public CurrencyRateController(CurrencyRateMngService service) {
        this.service = service;
    }

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6c47\u7387")
    @ApiOperationSupport(order=1)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u6c47\u7387", dataPermissionEnabled=true)
    public ApiResult<PagingVO<CurrencyRatePageRespVO>> page(@RequestBody CurrencyRatePageQueryVO queryVO) {
        return this.service.page(queryVO);
    }

    @PatchMapping(value={"/switch/{id}/enabled"})
    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u6c47\u7387ID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.service.updateEnabled(id);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u6c47\u7387\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u6c47\u7387ID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u6c47\u7387\u8be6\u60c5")
    public ApiResult<CurrencyRateDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.service.get(id);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u6c47\u7387")
    @ApiOperationSupport(order=4)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u6c47\u7387", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid CurrencyRateSaveVO saveVO) {
        return this.service.save(saveVO);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u6c47\u7387\u4fe1\u606f")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u6c47\u7387ID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u6c47\u7387\u4fe1\u606f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.service.delete(id);
    }

    @ApiOperation(value="\u7b97\u6cd5\u7c7b\u578b")
    @ApiOperationSupport(order=11)
    @GetMapping(value={"/calcMethod"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u7b97\u6cd5\u7c7b\u578b")
    public ApiResult<List<CodeNameParam>> calcMethod() {
        List values = Arrays.stream(CurrencyRateCalcMethod.values()).map(t -> new CodeNameParam(t.name(), t.getDescription())).collect(Collectors.toList());
        return ApiResult.ok(values);
    }
}

