/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.entity.SysFrontTableCfgDO;
import com.elitescloud.cloudt.system.model.vo.save.extend.FrontTableCfgSaveVO;
import com.elitescloud.cloudt.system.service.FrontTableCfgService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u524d\u7aef\u8868\u683c\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/mng/frontTable/cfg"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_FrontTableCfg:\u9875\u9762\u8868\u683c\u914d\u7f6e", businessDoClass=SysFrontTableCfgDO.class)
public class FrontTableCfgController {
    private FrontTableCfgService service;

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u914d\u7f6e")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/save/user"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u7528\u6237\u914d\u7f6e", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> saveUserConfig(@RequestBody @Valid FrontTableCfgSaveVO saveVO) {
        return this.service.saveCfg(saveVO, false);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u914d\u7f6e")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="tableCode", value="\u8868\u683c\u7f16\u7801", required=true, paramType="query")
    @GetMapping(value={"/get/user"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u7528\u6237\u914d\u7f6e")
    public ApiResult<String> getUserConfig(@RequestParam(value="tableCode") @NotBlank(message="tableCode") @NotBlank(message="tableCode") String tableCode) {
        return this.service.getCfg(tableCode, false);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5168\u5c40\u914d\u7f6e")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/save/global"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u5168\u5c40\u914d\u7f6e", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> saveGlobalConfig(@RequestBody @Valid FrontTableCfgSaveVO saveVO) {
        return this.service.saveCfg(saveVO, true);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u914d\u7f6e")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="tableCode", value="\u8868\u683c\u7f16\u7801", required=true, paramType="query")
    @GetMapping(value={"/get/global"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u5168\u5c40\u914d\u7f6e")
    public ApiResult<String> getGlobalConfig(@RequestParam(value="tableCode") @NotBlank(message="tableCode") @NotBlank(message="tableCode") String tableCode) {
        return this.service.getCfg(tableCode, true);
    }

    @Autowired
    public void setService(FrontTableCfgService service) {
        this.service = service;
    }
}

