/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticeEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.NoticeSaveVO;
import com.elitescloud.cloudt.system.service.NoticeMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u516c\u544a\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/notice"}, produces={"application/json"})
@Validated
public class NoticeMngController {
    private final NoticeMngService service;

    public NoticeMngController(NoticeMngService service) {
        this.service = service;
    }

    @ApiOperation(value="\u4fdd\u5b58\u516c\u544a")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody @Valid NoticeSaveVO saveVO) {
        if (Boolean.TRUE.equals(saveVO.getSys())) {
            return this.service.saveSys(saveVO);
        }
        return this.service.save(saveVO);
    }

    @ApiOperation(value="\u5047\u5220\u9664\u516c\u544a")
    @ApiOperationSupport(order=2)
    @DeleteMapping(value={"/deleteFake"})
    public ApiResult<Set<Long>> deleteFake(@RequestBody @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") Set<Long> ids) {
        return this.service.delete(ids, false);
    }

    @ApiOperation(value="\u5220\u9664\u516c\u544a")
    @ApiOperationSupport(order=2)
    @DeleteMapping(value={"/delete"})
    public ApiResult<Set<Long>> delete(@RequestBody @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") Set<Long> ids) {
        return this.service.delete(ids, true);
    }

    @ApiOperation(value="\u53d1\u5e03\u516c\u544a")
    @ApiOperationSupport(order=3)
    @PatchMapping(value={"/publish"})
    public ApiResult<Set<Long>> execPublish(@RequestBody @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") Set<Long> ids) {
        return this.service.execPublish(ids);
    }

    @ApiOperation(value="\u64a4\u56de\u516c\u544a")
    @ApiOperationSupport(order=4)
    @PatchMapping(value={"/revoke"})
    public ApiResult<Set<Long>> execRevoke(@RequestBody @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") @NotEmpty(message="\u516c\u544aID\u4e3a\u7a7a") Set<Long> ids) {
        return this.service.execRevoke(ids);
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u544a\u7f16\u8f91\u4fe1\u606f")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u516c\u544aID", dataType="long", required=true)
    @GetMapping(value={"/edit"})
    public ApiResult<NoticeEditRespVO> getEditVO(@RequestParam(name="id") @NotNull(message="\u516c\u544aID\u4e3a\u7a7a") @NotNull(message="\u516c\u544aID\u4e3a\u7a7a") Long id) {
        return this.service.getEditVO(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/pageMng"})
    public ApiResult<PagingVO<NoticePageRespVO>> pageMng(@RequestBody NoticePageMngQueryVO queryVO) {
        if (Boolean.TRUE.equals(queryVO.getSys())) {
            return this.service.pageSysMng(queryVO);
        }
        return this.service.pageMng(queryVO);
    }
}

