/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiSaveParamVO;
import com.elitescloud.cloudt.system.service.ThirdApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e09\u65b9\u63a5\u53e3\u5bf9\u63a5\u5e73\u53f0(\u5bf9\u63a5\u7cfb\u7edf)"})
@RestController
@RequestMapping(value={"/infinity/server/platform"})
public class ThirdAPiMngController {
    private static final Logger log = LoggerFactory.getLogger(ThirdAPiMngController.class);
    private final ThirdApiService thirdAPiService;

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public ApiResult<List<ThirdApiRespVO>> query(@RequestBody ThirdApiQueryParamVO query) {
        log.info("[InfinityPlatform] query list param = {}", (Object)query);
        return ApiResult.ok(this.thirdAPiService.ThirdApiByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public ApiResult<ThirdApiRespVO> detail(@PathVariable(value="id") Long id) {
        log.info("[InfinityPlatform] query detail by id = {}", (Object)id);
        return ApiResult.ok((Object)this.thirdAPiService.ThirdApiById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody @Valid ThirdApiSaveParamVO saveParam) {
        log.info("[InfinityPlatform] create/update record, saveParam = {}", (Object)saveParam);
        return ApiResult.ok((Object)this.thirdAPiService.save(saveParam));
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664[\u9700\u8981\u63d0\u793a\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c]")
    @DeleteMapping(value={"/delete"})
    public ApiResult<Void> delete(@RequestBody List<Long> ids) {
        log.info("[InfinityPlatform] batch physical delete by ids = {}", ids);
        this.thirdAPiService.delete(ids);
        return ApiResult.ok();
    }

    public ThirdAPiMngController(ThirdApiService thirdAPiService) {
        this.thirdAPiService = thirdAPiService;
    }
}

