/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplImportRecordRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageMngRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TmplSaveVO;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.TmplMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/tmpl"}, produces={"application/json"})
@Api(tags={"\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\u7ba1\u7406"})
@ApiSupport(author="wang shao", order=12)
@Validated
@BusinessObject(businessType="Sys_Tmpl:\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f", businessDoClass=SysTmplDO.class)
public class TmplController {
    private static final Logger log = LoggerFactory.getLogger(TmplController.class);
    @Autowired
    private TmplMngService tmplService;
    @Autowired
    private TmplImportRecordService tmplImportRecordService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u677f")
    @ApiOperationSupport(order=1)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u6a21\u677f", dataPermissionEnabled=true)
    public ApiResult<PagingVO<TmplPageMngRespVO>> search(@RequestBody @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") TmplQueryParam queryParam) {
        return this.tmplService.search(queryParam);
    }

    @PostMapping(value={"/file"})
    @ApiOperation(value="\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6a21\u677f\u6587\u4ef6", required=true)})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPLOAD, operationDescription="\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6", logEnabled=true)
    public ApiResult<FileInfoVO> uploadTmpl(@NotNull(message="\u6a21\u677f\u6587\u4ef6\u4e3a\u7a7a") @RequestParam(name="file") @NotNull(message="\u6a21\u677f\u6587\u4ef6\u4e3a\u7a7a") MultipartFile file) {
        return this.tmplService.uploadTmpl(file);
    }

    @PostMapping(value={""})
    @ApiOperation(value="\u65b0\u589e\u6a21\u677f")
    @ApiOperationSupport(order=3)
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u65b0\u589e\u6a21\u677f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid TmplSaveVO saveVO) {
        return this.tmplService.save(saveVO);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u770b\u6a21\u677f\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u770b\u6a21\u677f\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<TmplEditRespVO> get(@PathVariable Long id) {
        return this.tmplService.get(id);
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u6a21\u677f")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u6a21\u677f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> update(@PathVariable Long id, @RequestBody @Valid TmplSaveVO saveVO) {
        return this.tmplService.update(id, saveVO);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u6a21\u677f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable Long id) {
        return this.tmplService.delete(id);
    }

    @PatchMapping(value={"/{id}/enabled"})
    @ApiOperation(value="\u542f\u7528\u3001\u505c\u7528\u6a21\u677f")
    @ApiOperationSupport(order=7)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u542f\u7528/\u505c\u7528\u6a21\u677f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> enable(@PathVariable Long id) {
        return this.tmplService.updateEnabled(id);
    }

    @GetMapping(value={"/file"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", produces="application/octet-stream")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileCode", value="\u6a21\u677f\u6587\u4ef6\u7684\u552f\u4e00\u6807\u8bc6", required=true, paramType="query")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6")
    public HttpEntity<StreamingResponseBody> download(String fileCode) {
        return this.tmplService.downloadByFileCode(fileCode);
    }

    @GetMapping(value={"/file/byTmplCode"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u7f16\u7801\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", produces="application/octet-stream")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u6587\u4ef6\u7f16\u7801", required=true, paramType="query")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u6839\u636e\u6a21\u677f\u7f16\u7801\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6")
    public HttpEntity<StreamingResponseBody> downloadByTmplCode(String tmplCode) {
        return this.tmplService.downloadByCode(tmplCode);
    }

    @DeleteMapping(value={"/file"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f\u6587\u4ef6")
    @ApiOperationSupport(order=9)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileCode", value="\u6a21\u677f\u6587\u4ef6\u7684\u552f\u4e00\u6807\u8bc6", required=true, paramType="query")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u6a21\u677f\u6587\u4ef6", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<String> deleteFile(@NotBlank(message="\u6587\u4ef6\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u6807\u8bc6\u4e3a\u7a7a") String fileCode) {
        return this.tmplService.deleteTmplFile(fileCode);
    }

    @PostMapping(value={"/{id}/import"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    public ApiResult<PagingVO<TmplImportRecordRespVO>> searchImport(@PathVariable Long id, @RequestBody @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") TmplImportQueryParam queryParam) {
        return this.tmplImportRecordService.searchImport(id, queryParam);
    }

    @GetMapping(value={"/record/{recordId}/files"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u7684\u6587\u4ef6\u5217\u8868")
    @ApiOperationSupport(order=22)
    @ApiImplicitParams(value={@ApiImplicitParam(name="importId", value="\u5bfc\u51fa\u8bb0\u5f55ID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u83b7\u53d6\u5bfc\u51fa\u7684\u6587\u4ef6\u5217\u8868")
    public ApiResult<List<FileObjRespVO<String>>> listFileOfExport(@PathVariable(value="recordId") Long recordId) {
        return this.tmplImportRecordService.listFileOfExport(recordId);
    }
}

